/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;

public class EdgeyViewPager
extends ViewPager {
    private int edgeSize = 16;
    private int mDefaultEdgeSize;
    private int mEdgeSize;
    float mStartDragX;
    OnSwipeOutListener mListener;

    public EdgeyViewPager(Context context) {
        super(context);
        this.init();
    }

    public EdgeyViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public void EdgeyViewPager(OnSwipeOutListener listener) {
        this.mListener = listener;
    }

    void init() {
        float density = this.getContext().getResources().getDisplayMetrics().density;
        this.mDefaultEdgeSize = (int)((float)this.edgeSize * density);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth = this.getMeasuredWidth();
        int maxGutterSize = measuredWidth / 10;
        this.mEdgeSize = Math.min(maxGutterSize, this.mDefaultEdgeSize);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.getCurrentItem() == this.getAdapter().getCount() - 1) {
            int action = ev.getAction();
            float x = ev.getX();
            switch (action & 0xFF) {
                case 0: {
                    this.mStartDragX = x;
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    if (x < this.mStartDragX) {
                        this.mListener.onSwipeOutAtEnd();
                        break;
                    }
                    this.mStartDragX = 0.0f;
                }
            }
        } else {
            if (ev.getAction() != 1 && ev.getX() < (float)this.mEdgeSize) {
                return false;
            }
            this.mStartDragX = 0.0f;
        }
        return super.onTouchEvent(ev);
    }

    public static interface OnSwipeOutListener {
        public void onSwipeOutAtEnd();
    }
}

