/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.ArrowKeyMovementMethod;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.EditText;
import android.widget.TextView;
import oak.R;
import oak.util.OakUtils;

public class CancelEditText
extends EditText {
    private Drawable mDrawable;
    private Drawable[] mCompoundDrawables;

    public CancelEditText(Context context) {
        this(context, null);
        this.setPaintFlags(this.getPaintFlags() | 0x80);
    }

    public CancelEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 16842862);
        this.setPaintFlags(this.getPaintFlags() | 0x80);
    }

    public CancelEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray typedArray;
        this.setPaintFlags(this.getPaintFlags() | 0x80);
        int cancelDrawableId = 0;
        if (attrs != null && (typedArray = context.obtainStyledAttributes(attrs, R.styleable.CancelEditText)) != null) {
            cancelDrawableId = typedArray.getResourceId(1, -1);
            if (cancelDrawableId != -1) {
                this.mDrawable = this.getResources().getDrawable(cancelDrawableId);
                this.addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                    }

                    public void onTextChanged(CharSequence s, int start, int before, int count) {
                        CancelEditText.this.showOrHideCancel();
                    }

                    public void afterTextChanged(Editable s) {
                    }
                });
                this.showOrHideCancel();
            }
            try {
                String fontName = typedArray.getString(0);
                if (fontName != null) {
                    this.setTypeface(OakUtils.getStaticTypeFace(context, fontName));
                }
            }
            catch (IllegalArgumentException e) {
                try {
                    String fontName;
                    int fontNameRes = typedArray.getResourceId(0, -1);
                    if (fontNameRes != -1 && (fontName = context.getString(fontNameRes)) != null) {
                        this.setTypeface(OakUtils.getStaticTypeFace(context, fontName));
                    }
                }
                catch (IllegalArgumentException f) {
                    f.printStackTrace();
                }
            }
            typedArray.recycle();
        }
        if (this.isInEditMode()) {
            return;
        }
    }

    public void showOrHideCancel() {
        this.setCancelVisible(this.getText().length() > 0);
    }

    private void setCancelVisible(boolean visible) {
        if (this.mCompoundDrawables == null) {
            this.mCompoundDrawables = this.getCompoundDrawables();
        }
        if (visible) {
            this.setCompoundDrawablesWithIntrinsicBounds(this.mCompoundDrawables[0], this.mCompoundDrawables[1], this.mDrawable, this.mCompoundDrawables[3]);
        } else {
            this.setCompoundDrawablesWithIntrinsicBounds(this.mCompoundDrawables[0], this.mCompoundDrawables[1], this.mCompoundDrawables[2], this.mCompoundDrawables[3]);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mDrawable != null && event.getX() > (float)(this.getWidth() - this.getPaddingRight() - this.mDrawable.getIntrinsicWidth())) {
            this.setText("");
            this.setCancelVisible(false);
        }
        return super.onTouchEvent(event);
    }

    protected boolean getDefaultEditable() {
        return true;
    }

    protected MovementMethod getDefaultMovementMethod() {
        return ArrowKeyMovementMethod.getInstance();
    }

    public Editable getText() {
        return super.getText();
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, TextView.BufferType.EDITABLE);
    }

    public void setSelection(int start, int stop) {
        Selection.setSelection((Spannable)this.getText(), (int)start, (int)stop);
    }

    public void setSelection(int index) {
        Selection.setSelection((Spannable)this.getText(), (int)index);
    }

    public void selectAll() {
        Selection.selectAll((Spannable)this.getText());
    }

    public void extendSelection(int index) {
        Selection.extendSelection((Spannable)this.getText(), (int)index);
    }

    public void setEllipsize(TextUtils.TruncateAt ellipsis) {
        if (ellipsis == TextUtils.TruncateAt.MARQUEE) {
            throw new IllegalArgumentException("EditText cannot use the ellipsize mode TextUtils.TruncateAt.MARQUEE");
        }
        super.setEllipsize(ellipsis);
    }
}

