/*
 * Decompiled with CFR 0.152.
 */
package oak.util;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.FloatMath;
import android.view.MotionEvent;
import android.view.ViewConfiguration;

public class ScaleGestureDetector {
    private static final float PRESSURE_THRESHOLD = 0.67f;
    private final Context mContext;
    private final OnScaleGestureListener mListener;
    private boolean mGestureInProgress;
    private MotionEvent mPrevEvent;
    private MotionEvent mCurrEvent;
    private float mFocusX;
    private float mFocusY;
    private float mPrevFingerDiffX;
    private float mPrevFingerDiffY;
    private float mCurrFingerDiffX;
    private float mCurrFingerDiffY;
    private float mCurrLen;
    private float mPrevLen;
    private float mScaleFactor;
    private float mCurrPressure;
    private float mPrevPressure;
    private long mTimeDelta;
    private final float mEdgeSlop;
    private float mRightSlopEdge;
    private float mBottomSlopEdge;
    private boolean mSloppyGesture;

    public ScaleGestureDetector(Context context, OnScaleGestureListener listener) {
        ViewConfiguration config = ViewConfiguration.get((Context)context);
        this.mContext = context;
        this.mListener = listener;
        this.mEdgeSlop = config.getScaledEdgeSlop();
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        boolean handled = true;
        if (!this.mGestureInProgress) {
            switch (action & 0xFF) {
                case 5: {
                    boolean p1sloppy;
                    DisplayMetrics metrics = this.mContext.getResources().getDisplayMetrics();
                    this.mRightSlopEdge = (float)metrics.widthPixels - this.mEdgeSlop;
                    this.mBottomSlopEdge = (float)metrics.heightPixels - this.mEdgeSlop;
                    this.reset();
                    this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
                    this.mTimeDelta = 0L;
                    this.setContext(event);
                    float edgeSlop = this.mEdgeSlop;
                    float rightSlop = this.mRightSlopEdge;
                    float bottomSlop = this.mBottomSlopEdge;
                    float x0 = event.getRawX();
                    float y0 = event.getRawY();
                    float x1 = ScaleGestureDetector.getRawX(event, 1);
                    float y1 = ScaleGestureDetector.getRawY(event, 1);
                    boolean p0sloppy = x0 < edgeSlop || y0 < edgeSlop || x0 > rightSlop || y0 > bottomSlop;
                    boolean bl = p1sloppy = x1 < edgeSlop || y1 < edgeSlop || x1 > rightSlop || y1 > bottomSlop;
                    if (p0sloppy && p1sloppy) {
                        this.mFocusX = -1.0f;
                        this.mFocusY = -1.0f;
                        this.mSloppyGesture = true;
                        break;
                    }
                    if (p0sloppy) {
                        this.mFocusX = event.getX(1);
                        this.mFocusY = event.getY(1);
                        this.mSloppyGesture = true;
                        break;
                    }
                    if (p1sloppy) {
                        this.mFocusX = event.getX(0);
                        this.mFocusY = event.getY(0);
                        this.mSloppyGesture = true;
                        break;
                    }
                    this.mGestureInProgress = this.mListener.onScaleBegin(this);
                    break;
                }
                case 2: {
                    boolean p1sloppy;
                    if (!this.mSloppyGesture) break;
                    float edgeSlop = this.mEdgeSlop;
                    float rightSlop = this.mRightSlopEdge;
                    float bottomSlop = this.mBottomSlopEdge;
                    float x0 = event.getRawX();
                    float y0 = event.getRawY();
                    float x1 = ScaleGestureDetector.getRawX(event, 1);
                    float y1 = ScaleGestureDetector.getRawY(event, 1);
                    boolean p0sloppy = x0 < edgeSlop || y0 < edgeSlop || x0 > rightSlop || y0 > bottomSlop;
                    boolean bl = p1sloppy = x1 < edgeSlop || y1 < edgeSlop || x1 > rightSlop || y1 > bottomSlop;
                    if (p0sloppy && p1sloppy) {
                        this.mFocusX = -1.0f;
                        this.mFocusY = -1.0f;
                        break;
                    }
                    if (p0sloppy) {
                        this.mFocusX = event.getX(1);
                        this.mFocusY = event.getY(1);
                        break;
                    }
                    if (p1sloppy) {
                        this.mFocusX = event.getX(0);
                        this.mFocusY = event.getY(0);
                        break;
                    }
                    this.mSloppyGesture = false;
                    this.mGestureInProgress = this.mListener.onScaleBegin(this);
                    break;
                }
                case 6: {
                    if (!this.mSloppyGesture) break;
                    int id2 = (action & 0xFF00) >> 8 == 0 ? 1 : 0;
                    this.mFocusX = event.getX(id2);
                    this.mFocusY = event.getY(id2);
                }
            }
        } else {
            switch (action & 0xFF) {
                case 6: {
                    this.setContext(event);
                    int id3 = (action & 0xFF00) >> 8 == 0 ? 1 : 0;
                    this.mFocusX = event.getX(id3);
                    this.mFocusY = event.getY(id3);
                    if (!this.mSloppyGesture) {
                        this.mListener.onScaleEnd(this);
                    }
                    this.reset();
                    break;
                }
                case 3: {
                    if (!this.mSloppyGesture) {
                        this.mListener.onScaleEnd(this);
                    }
                    this.reset();
                    break;
                }
                case 2: {
                    boolean updatePrevious;
                    this.setContext(event);
                    if (!(this.mCurrPressure / this.mPrevPressure > 0.67f) || !(updatePrevious = this.mListener.onScale(this))) break;
                    this.mPrevEvent.recycle();
                    this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
                }
            }
        }
        return handled;
    }

    private static float getRawX(MotionEvent event, int pointerIndex) {
        float offset = event.getX() - event.getRawX();
        return event.getX(pointerIndex) + offset;
    }

    private static float getRawY(MotionEvent event, int pointerIndex) {
        float offset = event.getY() - event.getRawY();
        return event.getY(pointerIndex) + offset;
    }

    private void setContext(MotionEvent curr) {
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
        }
        this.mCurrEvent = MotionEvent.obtain((MotionEvent)curr);
        this.mCurrLen = -1.0f;
        this.mPrevLen = -1.0f;
        this.mScaleFactor = -1.0f;
        MotionEvent prev = this.mPrevEvent;
        float px0 = prev.getX(0);
        float py0 = prev.getY(0);
        float px1 = prev.getX(1);
        float py1 = prev.getY(1);
        float cx0 = curr.getX(0);
        float cy0 = curr.getY(0);
        float cx1 = curr.getX(1);
        float cy1 = curr.getY(1);
        float pvx = px1 - px0;
        float pvy = py1 - py0;
        float cvx = cx1 - cx0;
        float cvy = cy1 - cy0;
        this.mPrevFingerDiffX = pvx;
        this.mPrevFingerDiffY = pvy;
        this.mCurrFingerDiffX = cvx;
        this.mCurrFingerDiffY = cvy;
        this.mFocusX = cx0 + cvx * 0.5f;
        this.mFocusY = cy0 + cvy * 0.5f;
        this.mTimeDelta = curr.getEventTime() - prev.getEventTime();
        this.mCurrPressure = curr.getPressure(0) + curr.getPressure(1);
        this.mPrevPressure = prev.getPressure(0) + prev.getPressure(1);
    }

    private void reset() {
        if (this.mPrevEvent != null) {
            this.mPrevEvent.recycle();
            this.mPrevEvent = null;
        }
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
            this.mCurrEvent = null;
        }
        this.mSloppyGesture = false;
        this.mGestureInProgress = false;
    }

    public boolean isInProgress() {
        return this.mGestureInProgress;
    }

    public float getFocusX() {
        return this.mFocusX;
    }

    public float getFocusY() {
        return this.mFocusY;
    }

    public float getCurrentSpan() {
        if (this.mCurrLen == -1.0f) {
            float cvx = this.mCurrFingerDiffX;
            float cvy = this.mCurrFingerDiffY;
            this.mCurrLen = FloatMath.sqrt((float)(cvx * cvx + cvy * cvy));
        }
        return this.mCurrLen;
    }

    public float getPreviousSpan() {
        if (this.mPrevLen == -1.0f) {
            float pvx = this.mPrevFingerDiffX;
            float pvy = this.mPrevFingerDiffY;
            this.mPrevLen = FloatMath.sqrt((float)(pvx * pvx + pvy * pvy));
        }
        return this.mPrevLen;
    }

    public float getScaleFactor() {
        if (this.mScaleFactor == -1.0f) {
            this.mScaleFactor = this.getCurrentSpan() / this.getPreviousSpan();
        }
        return this.mScaleFactor;
    }

    public long getTimeDelta() {
        return this.mTimeDelta;
    }

    public long getEventTime() {
        return this.mCurrEvent.getEventTime();
    }

    public static class SimpleOnScaleGestureListener
    implements OnScaleGestureListener {
        @Override
        public boolean onScale(ScaleGestureDetector detector) {
            return false;
        }

        @Override
        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        @Override
        public void onScaleEnd(ScaleGestureDetector detector) {
        }
    }

    public static interface OnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector var1);

        public boolean onScaleBegin(ScaleGestureDetector var1);

        public void onScaleEnd(ScaleGestureDetector var1);
    }
}

