/*
 * Decompiled with CFR 0.152.
 */
package oak.activity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.widget.FrameLayout;
import oak.R;
import oak.activity.SupportFragmentHostActivity;

@TargetApi(value=11)
public class FragmentHostActivity
extends Activity {
    public static final String ACTION_BAR_TITLE_KEY = "FragmentHostActivity_ActionBarTitleKey";
    public static final String FRAGMENT_CLASS_NAME_KEY = "FragmentHostActivity_FragmentClassNameKey";
    private FrameLayout frameLayout;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_fragment_host);
        this.frameLayout = (FrameLayout)this.findViewById(R.id.oak_content);
        this.getActionBar().setDisplayHomeAsUpEnabled(true);
        Bundle extras = this.getIntent().getExtras();
        if (extras != null && extras.containsKey(ACTION_BAR_TITLE_KEY)) {
            this.setActionBarTitle(extras.getString(ACTION_BAR_TITLE_KEY));
        }
        if (extras != null && extras.containsKey(FRAGMENT_CLASS_NAME_KEY)) {
            String fragmentTag = extras.getString(FRAGMENT_CLASS_NAME_KEY);
            if (this.getFragmentManager().findFragmentByTag(fragmentTag) == null) {
                Fragment fragment = Fragment.instantiate((Context)this, (String)fragmentTag, null);
                Bundle bundle = new Bundle();
                bundle.putAll(extras);
                fragment.setArguments(bundle);
                FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
                fragmentTransaction.disallowAddToBackStack();
                fragmentTransaction.replace(R.id.oak_content, fragment, fragmentTag);
                fragmentTransaction.commit();
            }
        }
    }

    public FrameLayout getFrameLayout() {
        return this.frameLayout;
    }

    public void setActionBarTitle(int stringResId) {
        this.setActionBarTitle(this.getString(stringResId));
    }

    public void setActionBarTitle(String title) {
        this.getActionBar().setTitle((CharSequence)title);
    }

    public static Intent getIntent(Context context, String actionBarTitle, Class clazz, Bundle extras) {
        Intent intent = new Intent(context, SupportFragmentHostActivity.class);
        intent.putExtra(ACTION_BAR_TITLE_KEY, actionBarTitle);
        intent.putExtra(FRAGMENT_CLASS_NAME_KEY, clazz.getName());
        if (extras != null) {
            intent.putExtras(extras);
        }
        return intent;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

