/*
 * Decompiled with CFR 0.152.
 */
package oak;

public class Result<T, E extends Exception> {
    private T mValue;
    private E mError;
    private boolean mIsSuccess;

    public static <T, E extends Exception> Result<T, E> success(T value) {
        return new Result<T, T>(value);
    }

    public static <T, E extends Exception> Result<T, E> error(E error) {
        return new Result<T, E>(error);
    }

    protected Result(T result) {
        this.mValue = result;
        this.mIsSuccess = true;
    }

    protected Result(E error) {
        this.mError = error;
        this.mIsSuccess = false;
    }

    public boolean isSuccess() {
        return this.mIsSuccess;
    }

    public boolean isError() {
        return !this.mIsSuccess;
    }

    public T get() throws E {
        if (this.isSuccess()) {
            return this.mValue;
        }
        throw this.mError;
    }

    public T getSuccess() {
        if (this.mIsSuccess) {
            return this.mValue;
        }
        throw new IllegalStateException("Result was not a success");
    }

    public E getError() {
        if (!this.mIsSuccess) {
            return this.mError;
        }
        throw new IllegalStateException("Result was not an error");
    }
}

