/*
 * Decompiled with CFR 0.152.
 */
package oak;

import android.content.Context;
import android.content.SharedPreferences;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oak.Base64;

public abstract class CryptoSharedPreferences
implements SharedPreferences {
    private static final String CRYPTO_TYPE_KEY = "CryptoSharedPrefs_Type_Key";
    protected static final String UTF8 = "utf-8";
    protected static final int SECRET_KEY_ITERATIONS = 100;
    protected static final int IV_LENGTH = 16;
    protected static final String RANDOM_ALGORITHM = "SHA1PRNG";
    protected static final String CIPHER_ALGORITHM_AES = "AES/CBC/PKCS5Padding";
    protected static final String PBE_ALGORITHM_AES = "PBKDF2WithHmacSHA1";
    private static final String SECRET_KEY_ALGORITHM_AES = "AES";
    protected static final String CIPHER_ALGORITHM_DES = "PBEWithMD5AndDES";
    protected static final String PBE_ALGORITHM_DES = "PBEWithMD5AndDES";
    protected SharedPreferences delegate;
    protected Context context;
    private int cryptoToUse;
    public static final int CRYPTO_AES = 0;
    public static final int CRYPTO_DES = 1;
    private static byte[] SALT = new byte[]{98, 72, -55, -40, -125, -56, -21, 72, -69, -57, 70, 20, -32, 64, -72, 20, -67, 33, -41, -35};

    public CryptoSharedPreferences(Context context, SharedPreferences delegate) {
        this.delegate = delegate;
        this.context = context;
        this.initCryptoType();
    }

    private void initCryptoType() {
        int cryptoType = this.delegate.getInt(CRYPTO_TYPE_KEY, -1);
        if (cryptoType == 0 || cryptoType == 1) {
            this.cryptoToUse = cryptoType;
            return;
        }
        this.cryptoToUse = 0;
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_AES);
        }
        catch (NoSuchAlgorithmException ae) {
            ae.printStackTrace();
            this.cryptoToUse = 1;
        }
        catch (NoSuchPaddingException pe) {
            pe.printStackTrace();
            this.cryptoToUse = 1;
        }
        this.delegate.edit().putInt(CRYPTO_TYPE_KEY, this.cryptoToUse).commit();
    }

    protected abstract char[] getSpecialCode();

    public Editor edit() {
        return new Editor();
    }

    public Map<String, ?> getAll() {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String key, boolean defValue) {
        String v = this.delegate.getString(key, null);
        return v != null ? Boolean.parseBoolean(this.decrypt(v)) : defValue;
    }

    public float getFloat(String key, float defValue) {
        String v = this.delegate.getString(key, null);
        return v != null ? Float.parseFloat(this.decrypt(v)) : defValue;
    }

    public int getInt(String key, int defValue) {
        String v = this.delegate.getString(key, null);
        return v != null ? Integer.parseInt(this.decrypt(v)) : defValue;
    }

    public long getLong(String key, long defValue) {
        String v = this.delegate.getString(key, null);
        return v != null ? Long.parseLong(this.decrypt(v)) : defValue;
    }

    public String getString(String key, String defValue) {
        String v = this.delegate.getString(key, null);
        return v != null ? this.decrypt(v) : defValue;
    }

    public boolean contains(String s) {
        return this.delegate.contains(s);
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
        this.delegate.registerOnSharedPreferenceChangeListener(onSharedPreferenceChangeListener);
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
        this.delegate.unregisterOnSharedPreferenceChangeListener(onSharedPreferenceChangeListener);
    }

    protected String encrypt(String value) {
        if (1 == this.cryptoToUse) {
            return this.encrypt_DES(value);
        }
        return this.encrypt_AES(value);
    }

    protected String decrypt(String value) {
        if (1 == this.cryptoToUse) {
            return this.decrypt_DES(value);
        }
        return this.decrypt_AES(value);
    }

    protected String encrypt_AES(String value) {
        try {
            byte[] bytes = value != null ? value.getBytes(UTF8) : new byte[]{};
            byte[] ivBytes = this.getInitVector();
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            SecretKey symKey = this.getSecretKey_AES(SALT);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_AES);
            cipher.init(1, (Key)symKey, iv);
            byte[] encryptedBytes = cipher.doFinal(bytes);
            byte[] encryptedAndIv = new byte[encryptedBytes.length + ivBytes.length];
            System.arraycopy(encryptedBytes, 0, encryptedAndIv, 0, encryptedBytes.length);
            System.arraycopy(ivBytes, 0, encryptedAndIv, encryptedBytes.length, ivBytes.length);
            return new String(Base64.encode(encryptedAndIv, 2), UTF8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String decrypt_AES(String value) {
        try {
            byte[] bytes;
            byte[] byArray = bytes = value != null ? Base64.decode(value, 0) : new byte[]{};
            if (bytes.length <= 16) {
                return "";
            }
            byte[] ivBytes = this.copyOfRange(bytes, bytes.length - 16, bytes.length);
            byte[] encryptedBytes = this.copyOfRange(bytes, 0, bytes.length - 16);
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            SecretKey symKey = this.getSecretKey_AES(SALT);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_AES);
            cipher.init(2, (Key)symKey, iv);
            return new String(cipher.doFinal(encryptedBytes), UTF8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String encrypt_DES(String value) {
        try {
            byte[] bytes = value != null ? value.getBytes(UTF8) : new byte[]{};
            byte[] ivBytes = this.getInitVector();
            PBEParameterSpec iv = new PBEParameterSpec(ivBytes, 20);
            SecretKey key = this.getSecretKey_DES();
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(1, (Key)key, iv);
            byte[] encryptedBytes = pbeCipher.doFinal(bytes);
            byte[] encryptedAndIv = new byte[encryptedBytes.length + ivBytes.length];
            System.arraycopy(encryptedBytes, 0, encryptedAndIv, 0, encryptedBytes.length);
            System.arraycopy(ivBytes, 0, encryptedAndIv, encryptedBytes.length, ivBytes.length);
            return new String(Base64.encode(encryptedAndIv, 2), UTF8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String decrypt_DES(String value) {
        try {
            byte[] bytes;
            byte[] byArray = bytes = value != null ? Base64.decode(value, 0) : new byte[]{};
            if (bytes.length <= 16) {
                return "";
            }
            byte[] ivBytes = this.copyOfRange(bytes, bytes.length - 16, bytes.length);
            byte[] encryptedBytes = this.copyOfRange(bytes, 0, bytes.length - 16);
            PBEParameterSpec iv = new PBEParameterSpec(ivBytes, 20);
            SecretKey key = this.getSecretKey_DES();
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(2, (Key)key, iv);
            return new String(pbeCipher.doFinal(encryptedBytes), UTF8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getInitVector() throws NoSuchAlgorithmException {
        SecureRandom random = SecureRandom.getInstance(RANDOM_ALGORITHM);
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        return iv;
    }

    private SecretKey getSecretKey_DES() throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec keySpec = new PBEKeySpec(this.getSpecialCode());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey key = keyFactory.generateSecret(keySpec);
        return key;
    }

    private SecretKey getSecretKey_AES(byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(PBE_ALGORITHM_AES);
        PBEKeySpec spec = new PBEKeySpec(this.getSpecialCode(), salt, 100, 256);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), SECRET_KEY_ALGORITHM_AES);
        return secret;
    }

    private byte[] copyOfRange(byte[] from, int start, int end) {
        int length = end - start;
        byte[] result = new byte[length];
        System.arraycopy(from, start, result, 0, length);
        return result;
    }

    public class Editor
    implements SharedPreferences.Editor {
        protected SharedPreferences.Editor delegate;

        public Editor() {
            this.delegate = CryptoSharedPreferences.this.delegate.edit();
        }

        public Editor putBoolean(String key, boolean value) {
            String eValue = CryptoSharedPreferences.this.encrypt(Boolean.toString(value));
            this.delegate.putString(key, eValue);
            return this;
        }

        public Editor putFloat(String key, float value) {
            this.delegate.putString(key, CryptoSharedPreferences.this.encrypt(Float.toString(value)));
            return this;
        }

        public Editor putInt(String key, int value) {
            this.delegate.putString(key, CryptoSharedPreferences.this.encrypt(Integer.toString(value)));
            return this;
        }

        public Editor putLong(String key, long value) {
            this.delegate.putString(key, CryptoSharedPreferences.this.encrypt(Long.toString(value)));
            return this;
        }

        public Editor putString(String key, String value) {
            this.delegate.putString(key, CryptoSharedPreferences.this.encrypt(value));
            return this;
        }

        public SharedPreferences.Editor putStringSet(String s, Set<String> strings) {
            return null;
        }

        public Editor clear() {
            this.delegate.clear();
            return this;
        }

        public boolean commit() {
            return this.delegate.commit();
        }

        public void apply() {
        }

        public Editor remove(String s) {
            this.delegate.remove(s);
            return this;
        }
    }
}

