/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import java.text.ParseException;
import oak.util.MathUtil;
import oak.util.SvgPathParser;
import oak.util.WtaLogoPaths;

public class AnimatedWtaLogoView
extends View {
    private static final String TAG = "AnimatedWtaLogoView";
    private static final int TRACE_TIME = 2000;
    private static final int TRACE_TIME_PER_GLYPH = 1000;
    private static final int FILL_START = 1200;
    private static final int FILL_TIME = 2000;
    private static final int MARKER_LENGTH_DIP = 16;
    private static final int TRACE_RESIDUE_COLOR = Color.argb((int)50, (int)0, (int)0, (int)0);
    private static final int TRACE_COLOR = -16777216;
    private static final PointF VIEWPORT = new PointF(433.0f, 433.0f);
    private static final Interpolator INTERPOLATOR = new DecelerateInterpolator();
    private Paint mFillPaint;
    private GlyphData[] mGlyphData;
    private float mMarkerLength;
    private int mWidth;
    private int mHeight;
    private long mStartTime;
    public static final int STATE_NOT_STARTED = 0;
    public static final int STATE_TRACE_STARTED = 1;
    public static final int STATE_FILL_STARTED = 2;
    public static final int STATE_FINISHED = 3;
    private int mState = 0;
    private OnStateChangeListener mOnStateChangeListener;

    public AnimatedWtaLogoView(Context context) {
        super(context);
        this.init();
    }

    public AnimatedWtaLogoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AnimatedWtaLogoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.mFillPaint = new Paint();
        this.mFillPaint.setAntiAlias(true);
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mMarkerLength = TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.setLayerType(1, null);
    }

    public void start() {
        this.mStartTime = System.currentTimeMillis();
        this.changeState(1);
        this.postInvalidateOnAnimation();
    }

    public void reset() {
        this.mStartTime = 0L;
        this.changeState(0);
        this.postInvalidateOnAnimation();
    }

    public void setToFinishedFrame() {
        this.mStartTime = 1L;
        this.changeState(3);
        this.postInvalidateOnAnimation();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        this.rebuildGlyphData();
    }

    private void rebuildGlyphData() {
        SvgPathParser parser = new SvgPathParser(){

            @Override
            protected float transformX(float x) {
                return x * (float)AnimatedWtaLogoView.this.mWidth / VIEWPORT.x;
            }

            @Override
            protected float transformY(float y) {
                return y * (float)AnimatedWtaLogoView.this.mHeight / VIEWPORT.y;
            }
        };
        this.mGlyphData = new GlyphData[WtaLogoPaths.GLYPHS.length];
        for (int i = 0; i < WtaLogoPaths.GLYPHS.length; ++i) {
            this.mGlyphData[i] = new GlyphData();
            try {
                this.mGlyphData[i].path = parser.parsePath(WtaLogoPaths.GLYPHS[i]);
            }
            catch (ParseException e) {
                this.mGlyphData[i].path = new Path();
                Log.e((String)TAG, (String)"Couldn't parse path", (Throwable)e);
            }
            PathMeasure pm = new PathMeasure(this.mGlyphData[i].path, true);
            do {
                this.mGlyphData[i].length = Math.max(this.mGlyphData[i].length, pm.getLength());
            } while (pm.nextContour());
            this.mGlyphData[i].paint = new Paint();
            this.mGlyphData[i].paint.setStyle(Paint.Style.STROKE);
            this.mGlyphData[i].paint.setAntiAlias(true);
            this.mGlyphData[i].paint.setColor(-1);
            this.mGlyphData[i].paint.setStrokeWidth(TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mState == 0 || this.mGlyphData == null) {
            return;
        }
        long t = System.currentTimeMillis() - this.mStartTime;
        for (int i = 0; i < this.mGlyphData.length; ++i) {
            float phase = MathUtil.constrain(0.0f, 1.0f, ((float)t - (float)(1000 * i) * 1.0f / (float)this.mGlyphData.length) * 1.0f / 1000.0f);
            float distance = INTERPOLATOR.getInterpolation(phase) * this.mGlyphData[i].length;
            this.mGlyphData[i].paint.setColor(TRACE_RESIDUE_COLOR);
            this.mGlyphData[i].paint.setPathEffect((PathEffect)new DashPathEffect(new float[]{distance, this.mGlyphData[i].length}, 0.0f));
            canvas.drawPath(this.mGlyphData[i].path, this.mGlyphData[i].paint);
            this.mGlyphData[i].paint.setColor(-16777216);
            this.mGlyphData[i].paint.setPathEffect((PathEffect)new DashPathEffect(new float[]{0.0f, distance, phase > 0.0f ? this.mMarkerLength : 0.0f, this.mGlyphData[i].length}, 0.0f));
            canvas.drawPath(this.mGlyphData[i].path, this.mGlyphData[i].paint);
        }
        if (t > 1200L) {
            if (this.mState < 2) {
                this.changeState(2);
            }
            float phase = MathUtil.constrain(0.0f, 1.0f, (float)(t - 1200L) * 1.0f / 2000.0f);
            this.mFillPaint.setARGB((int)(phase * 255.0f), 136, 194, 200);
            for (GlyphData glyphData : this.mGlyphData) {
                canvas.drawPath(glyphData.path, this.mFillPaint);
            }
        }
        if (t < 3200L) {
            this.postInvalidateOnAnimation();
        } else {
            this.changeState(3);
        }
    }

    private void changeState(int state) {
        if (this.mState == state) {
            return;
        }
        this.mState = state;
        if (this.mOnStateChangeListener != null) {
            this.mOnStateChangeListener.onStateChange(state);
        }
    }

    public void setOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        this.mOnStateChangeListener = onStateChangeListener;
    }

    private static class GlyphData {
        Path path;
        Paint paint;
        float length;

        private GlyphData() {
        }
    }

    public static interface OnStateChangeListener {
        public void onStateChange(int var1);
    }
}

