/*
 * Decompiled with CFR 0.152.
 */
package oak.web;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import oak.R;

public class OakWebViewFragment
extends Fragment {
    private String url;
    public WebView webView;

    public static OakWebViewFragment getInstance(String url) {
        OakWebViewFragment fragment = new OakWebViewFragment();
        Bundle bundle = new Bundle();
        bundle.putString("oak_url", url);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.url = this.getArguments().getString("oak_url");
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.webview, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        View back = view.findViewById(R.id.back);
        View fwd = view.findViewById(R.id.forward);
        View refresh = view.findViewById(R.id.refresh);
        this.webView = (WebView)view.findViewById(R.id.webview);
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                return true;
            }
        });
        back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (OakWebViewFragment.this.webView.canGoBack()) {
                    OakWebViewFragment.this.webView.goBack();
                }
            }
        });
        fwd.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (OakWebViewFragment.this.webView.canGoForward()) {
                    OakWebViewFragment.this.webView.goForward();
                }
            }
        });
        refresh.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                OakWebViewFragment.this.webView.loadUrl(OakWebViewFragment.this.webView.getUrl());
            }
        });
        this.webView.loadUrl(this.url);
    }
}

