/*
 * Decompiled with CFR 0.152.
 */
package oak.util;

import android.graphics.Path;
import android.graphics.PointF;
import java.text.ParseException;

public class SvgPathParser {
    private static final int TOKEN_ABSOLUTE_COMMAND = 1;
    private static final int TOKEN_RELATIVE_COMMAND = 2;
    private static final int TOKEN_VALUE = 3;
    private static final int TOKEN_EOF = 4;
    private int mCurrentToken;
    private PointF mCurrentPoint = new PointF();
    private int mLength;
    private int mIndex;
    private String mPathString;

    protected float transformX(float x) {
        return x;
    }

    protected float transformY(float y) {
        return y;
    }

    public Path parsePath(String s) throws ParseException {
        this.mCurrentPoint.set(Float.NaN, Float.NaN);
        this.mPathString = s;
        this.mIndex = 0;
        this.mLength = this.mPathString.length();
        PointF tempPoint1 = new PointF();
        PointF tempPoint2 = new PointF();
        PointF tempPoint3 = new PointF();
        Path p = new Path();
        p.setFillType(Path.FillType.WINDING);
        boolean firstMove = true;
        while (this.mIndex < this.mLength) {
            char command = this.consumeCommand();
            boolean relative = this.mCurrentToken == 2;
            switch (command) {
                case 'M': 
                case 'm': {
                    boolean firstPoint = true;
                    while (this.advanceToNextToken() == 3) {
                        this.consumeAndTransformPoint(tempPoint1, relative && this.mCurrentPoint.x != Float.NaN);
                        if (firstPoint) {
                            p.moveTo(tempPoint1.x, tempPoint1.y);
                            firstPoint = false;
                            if (!firstMove) continue;
                            this.mCurrentPoint.set(tempPoint1);
                            firstMove = false;
                            continue;
                        }
                        p.lineTo(tempPoint1.x, tempPoint1.y);
                    }
                    this.mCurrentPoint.set(tempPoint1);
                    break;
                }
                case 'C': 
                case 'c': {
                    if (this.mCurrentPoint.x == Float.NaN) {
                        throw new ParseException("Relative commands require current point", this.mIndex);
                    }
                    while (this.advanceToNextToken() == 3) {
                        this.consumeAndTransformPoint(tempPoint1, relative);
                        this.consumeAndTransformPoint(tempPoint2, relative);
                        this.consumeAndTransformPoint(tempPoint3, relative);
                        p.cubicTo(tempPoint1.x, tempPoint1.y, tempPoint2.x, tempPoint2.y, tempPoint3.x, tempPoint3.y);
                    }
                    this.mCurrentPoint.set(tempPoint3);
                    break;
                }
                case 'L': 
                case 'l': {
                    if (this.mCurrentPoint.x == Float.NaN) {
                        throw new ParseException("Relative commands require current point", this.mIndex);
                    }
                    while (this.advanceToNextToken() == 3) {
                        this.consumeAndTransformPoint(tempPoint1, relative);
                        p.lineTo(tempPoint1.x, tempPoint1.y);
                    }
                    this.mCurrentPoint.set(tempPoint1);
                    break;
                }
                case 'H': 
                case 'h': {
                    if (this.mCurrentPoint.x == Float.NaN) {
                        throw new ParseException("Relative commands require current point", this.mIndex);
                    }
                    while (this.advanceToNextToken() == 3) {
                        float x = this.transformX(this.consumeValue());
                        if (relative) {
                            x += this.mCurrentPoint.x;
                        }
                        p.lineTo(x, this.mCurrentPoint.y);
                    }
                    this.mCurrentPoint.set(tempPoint1);
                    break;
                }
                case 'V': 
                case 'v': {
                    if (this.mCurrentPoint.x == Float.NaN) {
                        throw new ParseException("Relative commands require current point", this.mIndex);
                    }
                    while (this.advanceToNextToken() == 3) {
                        float y = this.transformY(this.consumeValue());
                        if (relative) {
                            y += this.mCurrentPoint.y;
                        }
                        p.lineTo(this.mCurrentPoint.x, y);
                    }
                    this.mCurrentPoint.set(tempPoint1);
                    break;
                }
                case 'Z': 
                case 'z': {
                    p.close();
                }
            }
        }
        return p;
    }

    private int advanceToNextToken() {
        while (this.mIndex < this.mLength) {
            char c = this.mPathString.charAt(this.mIndex);
            if ('a' <= c && c <= 'z') {
                this.mCurrentToken = 2;
                return 2;
            }
            if ('A' <= c && c <= 'Z') {
                this.mCurrentToken = 1;
                return 1;
            }
            if ('0' <= c && c <= '9' || c == '.' || c == '-') {
                this.mCurrentToken = 3;
                return 3;
            }
            ++this.mIndex;
        }
        this.mCurrentToken = 4;
        return 4;
    }

    private char consumeCommand() throws ParseException {
        this.advanceToNextToken();
        if (this.mCurrentToken != 2 && this.mCurrentToken != 1) {
            throw new ParseException("Expected command", this.mIndex);
        }
        return this.mPathString.charAt(this.mIndex++);
    }

    private void consumeAndTransformPoint(PointF out, boolean relative) throws ParseException {
        out.x = this.transformX(this.consumeValue());
        out.y = this.transformY(this.consumeValue());
        if (relative) {
            out.x += this.mCurrentPoint.x;
            out.y += this.mCurrentPoint.y;
        }
    }

    private float consumeValue() throws ParseException {
        char c;
        int index;
        this.advanceToNextToken();
        if (this.mCurrentToken != 3) {
            throw new ParseException("Expected value", this.mIndex);
        }
        boolean start = true;
        boolean seenDot = false;
        for (index = this.mIndex; index < this.mLength && ('0' <= (c = this.mPathString.charAt(index)) && c <= '9' || c == '.' && !seenDot || c == '-' && start); ++index) {
            if (c == '.') {
                seenDot = true;
            }
            start = false;
        }
        if (index == this.mIndex) {
            throw new ParseException("Expected value", this.mIndex);
        }
        String str = this.mPathString.substring(this.mIndex, index);
        try {
            float value = Float.parseFloat(str);
            this.mIndex = index;
            return value;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid float value '" + str + "'.", this.mIndex);
        }
    }
}

