/*
 * Decompiled with CFR 0.152.
 */
package oak.fragment;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Fragment;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Property;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import oak.R;
import oak.widget.AnimatedWtaLogoView;

public class AnimatedWtaLogoFragment
extends Fragment {
    private View mRootView;
    private Runnable mOnFillStartedCallback;
    private View mSubtitleView;
    private AnimatedWtaLogoView mLogoView;
    private float mInitialLogoOffset;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mInitialLogoOffset = TypedValue.applyDimension((int)1, (float)172.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.animated_wta_logo_fragment, container, false);
        this.mSubtitleView = this.mRootView.findViewById(R.id.logo_subtitle);
        this.mLogoView = (AnimatedWtaLogoView)this.mRootView.findViewById(R.id.animated_logo);
        this.mLogoView.setOnStateChangeListener(new AnimatedWtaLogoView.OnStateChangeListener(){

            @Override
            public void onStateChange(int state) {
                if (state == 2) {
                    AnimatedWtaLogoFragment.this.mSubtitleView.setAlpha(0.0f);
                    AnimatedWtaLogoFragment.this.mSubtitleView.setVisibility(0);
                    AnimatorSet set = new AnimatorSet();
                    AccelerateInterpolator interpolator = new AccelerateInterpolator();
                    ObjectAnimator a1 = ObjectAnimator.ofFloat((Object)((Object)AnimatedWtaLogoFragment.this.mLogoView), (Property)View.TRANSLATION_X, (float[])new float[]{0.0f});
                    ObjectAnimator a2 = ObjectAnimator.ofFloat((Object)AnimatedWtaLogoFragment.this.mSubtitleView, (Property)View.TRANSLATION_X, (float[])new float[]{0.0f});
                    ObjectAnimator a3 = ObjectAnimator.ofFloat((Object)AnimatedWtaLogoFragment.this.mSubtitleView, (Property)View.ALPHA, (float[])new float[]{1.0f});
                    a1.setInterpolator((TimeInterpolator)interpolator);
                    a2.setInterpolator((TimeInterpolator)interpolator);
                    set.setDuration(500L).playTogether(new Animator[]{a1, a2, a3});
                    set.start();
                    if (AnimatedWtaLogoFragment.this.mOnFillStartedCallback != null) {
                        AnimatedWtaLogoFragment.this.mOnFillStartedCallback.run();
                    }
                }
            }
        });
        return this.mRootView;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.reset();
    }

    public void start() {
        this.mLogoView.start();
    }

    public void setOnFillStartedCallback(Runnable fillStartedCallback) {
        this.mOnFillStartedCallback = fillStartedCallback;
    }

    public void reset() {
        this.mLogoView.reset();
        this.mLogoView.setTranslationX(this.mInitialLogoOffset / 2.0f);
        this.mSubtitleView.setVisibility(4);
    }
}

