/*
 * Decompiled with CFR 0.152.
 */
package oak.widget.spreadsheetview;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import oak.widget.spreadsheetview.SpreadsheetView;

public class SpreadsheetCell {
    private Paint cellPaint;
    private Paint selectedCellPaint;
    private Paint textPaint;
    private Paint selectedTextPaint;
    private Paint borderPaint;
    private Paint selectedBorderPaint;
    private float drawnWidth;
    private float drawnHeight;
    private float insetCellWidth;
    private float insetCellHeight;
    private SpreadsheetView table;
    private Drawable shape;
    private Drawable selectedShape;
    private float horizontalBorderWidth;
    private float verticalBorderWidth;

    public SpreadsheetCell(SpreadsheetView table, Paint cellPaint, Paint textPaint, Paint borderPaint, float horizontalBorderWidth, float verticalBorderWidth) {
        this.cellPaint = cellPaint;
        this.selectedCellPaint = new Paint(cellPaint);
        this.textPaint = textPaint;
        this.selectedTextPaint = new Paint(textPaint);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.selectedTextPaint.setTextAlign(Paint.Align.CENTER);
        this.borderPaint = borderPaint;
        this.selectedBorderPaint = new Paint(borderPaint);
        this.horizontalBorderWidth = horizontalBorderWidth;
        this.verticalBorderWidth = verticalBorderWidth;
        this.table = table;
        this.shape = null;
    }

    public SpreadsheetCell(SpreadsheetView table, Drawable shape, Drawable selectedShape, Paint borderPaint, Paint textPaint, float horizontalBorderWidth, float verticalBorderWidth) {
        this.table = table;
        this.shape = shape;
        this.selectedShape = selectedShape;
        this.textPaint = textPaint;
        this.borderPaint = borderPaint;
        this.selectedTextPaint = new Paint(textPaint);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.selectedTextPaint.setTextAlign(Paint.Align.CENTER);
        this.horizontalBorderWidth = horizontalBorderWidth;
        this.verticalBorderWidth = verticalBorderWidth;
        this.selectedBorderPaint = new Paint(borderPaint);
    }

    public void setTextSize(float size) {
        this.textPaint.setTextSize(size);
        this.selectedTextPaint.setTextSize(size);
    }

    public Paint getTextPaint() {
        return this.textPaint;
    }

    public void setTextPaint(Paint paint) {
        this.textPaint = paint;
    }

    public void setTypeface(Typeface typeface) {
        this.textPaint.setTypeface(typeface);
    }

    public Typeface getTypeface() {
        return this.textPaint.getTypeface();
    }

    public void setSelectedTypeface(Typeface typeface) {
        this.selectedTextPaint.setTypeface(typeface);
    }

    public void setTextColor(int color) {
        this.textPaint.setColor(color);
    }

    public int getTextColor() {
        return this.textPaint.getColor();
    }

    public Paint getSelectedTextPaint() {
        return this.selectedTextPaint;
    }

    public void setSelectedTextPaint(Paint paint) {
        this.selectedTextPaint = paint;
    }

    public void setSelectedTextColor(int color) {
        this.selectedTextPaint.setColor(color);
    }

    public int getSelectedTextColor() {
        return this.selectedTextPaint.getColor();
    }

    public void setSelectedTextSize(float size) {
        this.selectedTextPaint.setTextSize(size);
    }

    public float getSelectedTextSize() {
        return this.selectedTextPaint.getTextSize();
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint paint) {
        this.borderPaint = paint;
    }

    public Paint getSelectedBorderPaint() {
        return this.selectedBorderPaint;
    }

    public void setSelectedBorderPaint(Paint paint) {
        this.selectedBorderPaint = paint;
    }

    public Paint getCellPaint() {
        return this.cellPaint;
    }

    public void setCellPaint(Paint paint) {
        this.cellPaint = paint;
    }

    public Paint getSelectedCellPaint() {
        return this.selectedCellPaint;
    }

    public void setSelectedCellPaint(Paint paint) {
        this.selectedCellPaint = paint;
    }

    public Drawable getDrawable() {
        return this.shape;
    }

    public void setDrawable(Drawable drawable) {
        this.shape = drawable;
    }

    public Drawable getSelectedDrawable() {
        return this.selectedShape;
    }

    public void setSelectedDrawable(Drawable drawable) {
        this.selectedShape = drawable;
    }

    public void setHorizontalBorderWidth(float width) {
        this.horizontalBorderWidth = width;
    }

    public float getHorizontalBorderWidth() {
        return this.horizontalBorderWidth;
    }

    public void setVerticalBorderWidth(float width) {
        this.verticalBorderWidth = width;
    }

    public float getVerticalBorderWidth() {
        return this.verticalBorderWidth;
    }

    public void draw(Canvas canvas, String text, float leftX, float topY, float cellWidth, float cellHeight, boolean selected) {
        this.drawnWidth = cellWidth;
        this.drawnHeight = cellHeight;
        if (selected && this.selectedBorderPaint != null) {
            canvas.drawRect(leftX, topY, leftX + this.drawnWidth, topY + this.drawnHeight, this.selectedBorderPaint);
        } else if (this.borderPaint != null) {
            canvas.drawRect(leftX, topY, leftX + this.drawnWidth, topY + this.drawnHeight, this.borderPaint);
        }
        this.insetCellHeight = cellHeight - this.verticalBorderWidth * 2.0f;
        if (this.insetCellHeight < 0.0f) {
            this.insetCellHeight = 0.0f;
        }
        this.insetCellWidth = cellWidth - this.horizontalBorderWidth * 2.0f;
        if (this.insetCellWidth < 0.0f) {
            this.insetCellWidth = 0.0f;
        }
        if (selected) {
            if (this.selectedShape != null) {
                this.selectedShape.setBounds((int)(leftX + this.horizontalBorderWidth), (int)(topY + this.verticalBorderWidth), (int)(leftX + this.horizontalBorderWidth + this.insetCellWidth), (int)(topY + this.verticalBorderWidth + this.insetCellHeight));
                this.selectedShape.draw(canvas);
            } else {
                canvas.drawRect(leftX + this.horizontalBorderWidth, topY + this.verticalBorderWidth, leftX + this.horizontalBorderWidth + this.insetCellWidth, topY + this.verticalBorderWidth + this.insetCellHeight, this.selectedCellPaint);
            }
            if (text == null) {
                text = "null";
            }
            canvas.drawText(text, leftX + cellWidth / 2.0f, topY + cellHeight / 2.0f, this.selectedTextPaint);
        } else {
            if (this.shape != null) {
                this.shape.setBounds((int)(leftX + this.horizontalBorderWidth), (int)(topY + this.verticalBorderWidth), (int)(leftX + this.horizontalBorderWidth + this.insetCellWidth), (int)(topY + this.verticalBorderWidth + this.insetCellHeight));
                this.shape.draw(canvas);
            } else {
                canvas.drawRect(leftX + this.horizontalBorderWidth, topY + this.verticalBorderWidth, leftX + this.horizontalBorderWidth + this.insetCellWidth, topY + this.verticalBorderWidth + this.insetCellHeight, this.cellPaint);
            }
            if (text == null) {
                text = "null";
            }
            canvas.drawText(text, leftX + cellWidth / 2.0f, topY + cellHeight / 2.0f, this.textPaint);
        }
    }
}

