/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.TextView;
import oak.R;
import oak.util.OakUtils;

public class TextViewWithFont
extends TextView {
    public TextViewWithFont(Context context) {
        this(context, null);
        this.setPaintFlags(this.getPaintFlags() | 0x80);
    }

    public TextViewWithFont(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.setPaintFlags(this.getPaintFlags() | 0x80);
    }

    public TextViewWithFont(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray typedArray;
        this.setPaintFlags(this.getPaintFlags() | 0x80);
        if (this.isInEditMode()) {
            return;
        }
        String fontName = null;
        if (attrs != null && (typedArray = context.obtainStyledAttributes(attrs, R.styleable.TextViewWithFont)) != null) {
            try {
                fontName = typedArray.getString(0);
                if (fontName != null) {
                    this.setTypeface(OakUtils.getStaticTypeFace(context, fontName));
                }
            }
            catch (IllegalArgumentException e) {
                try {
                    int fontNameRes = typedArray.getResourceId(0, -1);
                    if (fontNameRes != -1 && (fontName = context.getString(fontNameRes)) != null) {
                        this.setTypeface(OakUtils.getStaticTypeFace(context, fontName));
                    }
                }
                catch (IllegalArgumentException f) {
                    f.printStackTrace();
                }
            }
            typedArray.recycle();
        }
    }
}

