/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import oak.R;

public class AspectRatioLayout
extends FrameLayout {
    private float mAspectRatio = 1.0f;

    public AspectRatioLayout(Context context) {
        super(context);
    }

    public AspectRatioLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AspectRatioLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray typedArray;
        if (attrs != null && (typedArray = context.obtainStyledAttributes(attrs, R.styleable.AspectRatioLayout)) != null) {
            this.mAspectRatio = typedArray.getFloat(0, 1.0f);
            typedArray.recycle();
        }
    }

    public void setAspectRatio(float ratio) {
        this.mAspectRatio = ratio;
        this.requestLayout();
    }

    public float getAspectRatio() {
        return this.mAspectRatio;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        float requestedRatio;
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (height == 0 && heightMode == 0) {
            height = Integer.MAX_VALUE;
        }
        if (width == 0 && widthMode == 0) {
            width = Integer.MAX_VALUE;
        }
        if ((requestedRatio = (float)width / (float)height) > this.mAspectRatio) {
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)((int)((float)height * this.mAspectRatio)), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        } else {
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)((int)((float)width / this.mAspectRatio)), (int)0x40000000));
        }
    }
}

