/*
 * Decompiled with CFR 0.152.
 */
package oak.viewmodel;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.List;
import oak.viewmodel.ViewModel;
import oak.viewmodel.ViewModelUtil;

public class ViewModelAdapter<T>
extends BaseAdapter {
    private Context mContext;
    private int mLayoutId;
    private List<T> mItems;

    public ViewModelAdapter(Context context, int layoutId, List<T> items) {
        this.mContext = context;
        this.mLayoutId = layoutId;
        this.mItems = items;
    }

    public int getCount() {
        return this.mItems.size();
    }

    public T getItem(int i) {
        return this.mItems.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int i, View convertView, ViewGroup parent) {
        ViewModel<T> view = ViewModelUtil.getViewModel(LayoutInflater.from((Context)this.mContext), this.mLayoutId, convertView, parent);
        view.populate(this.getItem(i));
        return (View)view;
    }

    public List<T> getItems() {
        return this.mItems;
    }

    public void replace(List<T> items) {
        this.mItems = items;
        this.notifyDataSetChanged();
    }

    protected Context getContext() {
        return this.mContext;
    }
}

