/*
 * Decompiled with CFR 0.152.
 */
package oak.util;

import android.content.Context;
import android.support.v4.content.AsyncTaskLoader;

public abstract class OakAsyncLoader<T>
extends AsyncTaskLoader<T> {
    T mData;

    public OakAsyncLoader(Context context) {
        super(context);
    }

    public void deliverResult(T data) {
        if (this.isReset() && data != null) {
            return;
        }
        T oldData = this.mData;
        this.mData = data;
        if (this.isStarted()) {
            super.deliverResult(data);
        }
    }

    protected void onStartLoading() {
        if (this.mData != null) {
            this.deliverResult(this.mData);
        }
        if (this.takeContentChanged()) {
            this.forceLoad();
        } else if (this.mData == null) {
            this.forceLoad();
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    protected void onReset() {
        this.onStopLoading();
        if (this.mData != null) {
            this.mData = null;
        }
    }
}

