/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.webkit.WebView;

public class BeastWebView
extends WebView {
    private float mCurrX = 0.0f;
    private float mCurrY = 0.0f;
    private int mTouchSlop;
    private boolean overScrollTop = false;
    private boolean overScrollLeft = false;
    private boolean overScrollRight = false;
    private boolean overScrollBottom = false;
    private boolean isScrolling = false;

    public BeastWebView(Context context) {
        super(context);
        this.init();
    }

    public BeastWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.mCurrX = event.getX();
            this.mCurrY = event.getY();
            this.getParent().requestDisallowInterceptTouchEvent(true);
        } else if (action != 2) {
            if (action == 1 || action == 3) {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            } else {
                this.getParent().requestDisallowInterceptTouchEvent(true);
            }
        }
        return super.onInterceptTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int scrollBarWidth = this.getVerticalScrollbarWidth();
        int viewWidth = this.computeHorizontalScrollExtent();
        int innerWidth = this.computeHorizontalScrollRange();
        int scrollBarLeftPos = this.computeHorizontalScrollOffset();
        int scrollBarRightPos = scrollBarLeftPos + viewWidth + scrollBarWidth;
        this.overScrollLeft = scrollBarLeftPos == 0;
        this.overScrollRight = scrollBarRightPos >= innerWidth;
        int scrollBarHeight = this.getHorizontalScrollbarHeight();
        int viewHeight = this.computeVerticalScrollExtent();
        int innerHeight = this.computeVerticalScrollRange();
        int scrollBarTopPos = this.computeVerticalScrollOffset();
        int scrollBarBottomPos = scrollBarTopPos + viewHeight + scrollBarHeight;
        this.overScrollTop = scrollBarTopPos == 0;
        this.overScrollBottom = scrollBarBottomPos >= innerHeight;
        int action = event.getAction();
        if (action == 2 && !this.isScrolling) {
            if (event.getX() - this.mCurrX > (float)this.mTouchSlop && this.overScrollLeft) {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            } else if (this.mCurrX - event.getX() > (float)this.mTouchSlop && this.overScrollRight) {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            } else if (event.getY() - this.mCurrY > (float)this.mTouchSlop && this.overScrollTop) {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            } else if (this.mCurrY - event.getY() > (float)this.mTouchSlop && this.overScrollBottom) {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        return super.onTouchEvent(event);
    }
}

