/*
 * Decompiled with CFR 0.152.
 */
package oak.http;

import android.content.Context;
import android.util.Log;
import com.squareup.okhttp.HttpResponseCache;
import com.squareup.okhttp.OkHttpClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ResponseCache;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import oak.Base64;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;

public class OkHttpTool {
    public static final String PUT = "PUT";
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String DELETE = "DELETE";
    private OkHttpClient mClient;
    private Map<String, String> mDefaultHeaders = new HashMap<String, String>();
    private Map<String, String> mCredentialsMap = new HashMap<String, String>();

    public OkHttpTool(Context context) {
        if (this.mClient == null) {
            this.mClient = new OkHttpClient();
            this.installCache(context);
        }
    }

    public OkHttpTool() {
        if (this.mClient == null) {
            this.mClient = new OkHttpClient();
        }
    }

    public OkHttpClient getClient() {
        return this.mClient;
    }

    public void setReadTimeout(long timeout) {
        this.mClient.setReadTimeout(timeout, TimeUnit.MILLISECONDS);
    }

    public void setConnectTimeout(long timeout) {
        this.mClient.setConnectTimeout(timeout, TimeUnit.MILLISECONDS);
    }

    public void setDefaultHeaders(Map<String, String> defaultHeaders) {
        this.mDefaultHeaders = defaultHeaders;
    }

    public Map<String, String> getDefaultHeaders() {
        return this.mDefaultHeaders;
    }

    private void installCache(Context context) {
        long httpCacheSize = 0xA00000L;
        File httpCacheDir = new File(context.getCacheDir(), "http");
        try {
            this.mClient.setResponseCache((ResponseCache)new HttpResponseCache(httpCacheDir, 0xA00000L));
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void configureDefaults(URLConnection connection) {
        for (String host : this.mCredentialsMap.keySet()) {
            if (!host.equalsIgnoreCase(connection.getURL().getHost())) continue;
            connection.setRequestProperty("Authorization", "Basic " + this.mCredentialsMap.get(host));
        }
        for (String key : this.mDefaultHeaders.keySet()) {
            connection.setRequestProperty(key, this.mDefaultHeaders.get(key));
        }
    }

    public HttpURLConnection get(String url) throws IOException {
        return this.connectAndDoOutput(url, null, GET);
    }

    public HttpURLConnection post(String url, StringEntity entity) throws IOException {
        return this.connectAndDoOutput(url, entity, POST);
    }

    public HttpURLConnection put(String url, StringEntity entity) throws IOException {
        return this.connectAndDoOutput(url, entity, PUT);
    }

    public HttpURLConnection delete(String url) throws IOException {
        return this.connectAndDoOutput(url, null, DELETE);
    }

    private HttpURLConnection connectAndDoOutput(String url, StringEntity entity, String method) throws IOException {
        URL typedUrl = new URL(url);
        HttpURLConnection connection = this.mClient.open(typedUrl);
        this.configureDefaults(connection);
        connection.setRequestMethod(method);
        if (entity != null) {
            connection.setDoInput(true);
            connection.setDoOutput(true);
            OutputStream out = connection.getOutputStream();
            entity.writeTo(out);
            out.close();
        }
        return connection;
    }

    @Deprecated
    public void setCertValidationDisabled(boolean isDisabled) {
        if (isDisabled) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            catch (Exception e) {
                Log.e((String)"OAK", (String)(e.getMessage() + ""));
            }
            X509HostnameVerifier allHostsValid = new X509HostnameVerifier(){

                public void verify(String s, SSLSocket sslSocket) throws IOException {
                }

                public void verify(String s, X509Certificate x509Certificate) throws SSLException {
                }

                public void verify(String s, String[] strings, String[] strings1) throws SSLException {
                }

                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)allHostsValid);
        }
    }

    public void setPreEmptiveBasicAuth(String targetHost, String username, String password) {
        if (targetHost == null || username == null || password == null) {
            throw new RuntimeException("Please supply targethost, username, and password credentials");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(username);
        sb.append(":");
        sb.append(password);
        String encodedBasicAuth = new String(Base64.encode(sb.toString().getBytes(), 2));
        this.mCredentialsMap.put(targetHost, encodedBasicAuth);
    }

    public BufferedReader getBufferedInputReader(HttpURLConnection connection) throws IOException {
        return new BufferedReader(new InputStreamReader(connection.getInputStream()));
    }
}

