/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;

public class RatioLinearLayout
extends LinearLayout {
    private int width;
    private int height;
    private static final int DEFAULT_WIDTH = 1;
    private static final int DEFAULT_HEIGHT = 1;

    public RatioLinearLayout(Context context) {
        super(context);
        this.initialize(null);
    }

    public RatioLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(attrs);
    }

    @TargetApi(value=11)
    public RatioLinearLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialize(attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int calculatedHeight = parentWidth / this.width * this.height;
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)parentWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)calculatedHeight, (int)0x40000000));
    }

    private void initialize(AttributeSet attrs) {
        if (attrs == null) {
            this.width = 1;
            this.height = 1;
        } else {
            this.width = attrs.getAttributeIntValue("http://oak/oak/schema", "ratioWidth", 1);
            this.height = attrs.getAttributeIntValue("http://oak/oak/schema", "ratioHeight", 1);
        }
    }
}

