/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ProgressBar;

public class CustomCircularProgressBar
extends ProgressBar {
    Context c;
    public RotateAnimation rotate;

    public CustomCircularProgressBar(Context context) {
        super(context);
        this.init(context, null);
    }

    public CustomCircularProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context c, AttributeSet attrs) {
        this.c = c;
        this.setIndeterminate(true);
        this.rotate = new RotateAnimation(360.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.rotate.setInterpolator((Interpolator)new LinearInterpolator());
        this.rotate.setDuration(1750L);
        this.rotate.setRepeatCount(-1);
        if (attrs != null) {
            Drawable d = c.getResources().getDrawable(attrs.getAttributeResourceValue("http://oak/oak/schema", "progressBarDrawable", -1));
            this.setIndeterminateDrawable(d);
        }
        this.setAnimation((Animation)this.rotate);
        this.rotate.start();
    }

    public void setVisibility(int visibility) {
        if (visibility == 8 || visibility == 4) {
            this.clearAnimation();
        } else if (visibility == 0) {
            this.setAnimation((Animation)this.rotate);
            this.rotate.start();
        }
        super.setVisibility(visibility);
    }
}

