/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.CheckBox;
import oak.util.OakUtils;

public class CheckBoxWithFont
extends CheckBox {
    private static final String TAG = CheckBoxWithFont.class.getSimpleName();

    public CheckBoxWithFont(Context context) {
        super(context);
        this.setPaintFlags(this.getPaintFlags() | 0x80);
    }

    public CheckBoxWithFont(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setPaintFlags(this.getPaintFlags() | 0x80);
        this.setFont(context, attrs);
    }

    public CheckBoxWithFont(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setPaintFlags(this.getPaintFlags() | 0x80);
        this.setFont(context, attrs);
    }

    private void setFont(Context context, AttributeSet attrs) {
        String fontName = null;
        if (attrs != null) {
            try {
                fontName = attrs.getAttributeValue("http://oak/oak/schema", "font");
                if (fontName != null) {
                    this.setTypeface(OakUtils.getStaticTypeFace(context, fontName));
                }
            }
            catch (IllegalArgumentException e) {
                try {
                    int fontNameRes = attrs.getAttributeResourceValue("http://oak/oak/schema", "font", -1);
                    if (fontNameRes != -1 && (fontName = context.getString(fontNameRes)) != null) {
                        this.setTypeface(OakUtils.getStaticTypeFace(context, fontName));
                    }
                }
                catch (IllegalArgumentException f) {
                    f.printStackTrace();
                }
            }
        }
    }
}

