/*
 * Decompiled with CFR 0.152.
 */
package oak;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.widget.Toast;
import com.google.inject.Inject;
import roboguice.inject.ContextSingleton;

@ContextSingleton
public class AsyncTool {
    @Inject
    Activity mActivity;
    private ProgressDialog mProgressDialog;
    private AlertDialog mAlertDialog;
    private static final int ERROR_DURATION = 1000;

    public AsyncTool() {
    }

    public AsyncTool(Activity activity) {
        this.mActivity = activity;
    }

    public AlertDialog getProgressDialog() {
        if (this.mProgressDialog == null) {
            this.mProgressDialog = new ProgressDialog((Context)this.mActivity);
            this.mProgressDialog.setIndeterminate(true);
        }
        return this.mProgressDialog;
    }

    private void setBusy(boolean busy) {
        if (busy) {
            this.getProgressDialog().show();
        } else {
            try {
                this.getProgressDialog().dismiss();
                this.mProgressDialog = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void displayAlertDialog(String message, boolean isError) {
        this.displayAlertDialog(message, isError, null);
    }

    void displayAlertDialog(String message, boolean isError, final DialogInterface.OnClickListener callback) {
        if (this.mAlertDialog == null) {
            int icon;
            String title;
            if (isError) {
                title = "Error";
                icon = 17301543;
            } else {
                title = null;
                icon = 17301659;
            }
            this.mAlertDialog = new AlertDialog.Builder((Context)this.mActivity).setIcon(icon).setTitle((CharSequence)title).setMessage((CharSequence)message).setCancelable(false).setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    AsyncTool.this.mAlertDialog = null;
                    if (callback != null) {
                        callback.onClick(dialogInterface, i);
                    }
                }
            }).show();
        } else {
            Toast toast = Toast.makeText((Context)this.mActivity, (CharSequence)message, (int)1000);
            toast.setGravity(48, 0, 50);
            toast.show();
        }
    }

    public static abstract class SimpleTask
    extends AsyncTask<Void, String, Void> {
        AsyncTool mAsyncTool;
        private Exception mException;

        public SimpleTask(AsyncTool asyncTool) {
            this.mAsyncTool = asyncTool;
        }

        public void onPreExecute() {
            this.mAsyncTool.setBusy(true);
        }

        public abstract void exceptionalLabor() throws Exception;

        protected void onProgressUpdate(String ... values) {
            super.onProgressUpdate((Object[])values);
            this.mAsyncTool.getProgressDialog().setMessage((CharSequence)values[0]);
        }

        public Void doInBackground(Void ... unused) {
            try {
                this.exceptionalLabor();
            }
            catch (Exception e) {
                this.mException = e;
            }
            return null;
        }

        public void onPostExecute(Void unused) {
            this.mAsyncTool.setBusy(false);
            if (this.mException != null && !this.mAsyncTool.mActivity.isFinishing()) {
                this.onError(this.mException);
            }
        }

        public void onError(Exception exception) {
            this.mAsyncTool.displayAlertDialog(exception.getMessage(), true);
        }

        public boolean isInError() {
            return this.mException != null;
        }
    }
}

