/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import oak.widget.SwankyImageView;

public class SwankyGallery
extends FrameLayout {
    private Context mContext;
    private SwankyViewPager mViewPager;
    private SwankyAdapter mAdapter;
    private static final BitmapFactory.Options LO_RES_OPTIONS = new BitmapFactory.Options();
    private static final BitmapFactory.Options HI_RES_OPTIONS = new BitmapFactory.Options();
    private float xPosPrev;
    private float mMaxZoom = 2.5f;
    private OnGalleryPageSelectedListener mPageSelectedListener = null;

    public SwankyGallery(Context context) {
        super(context);
        this.init(context, null);
    }

    public SwankyGallery(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SwankyGallery(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mContext = context;
        this.mViewPager = new SwankyViewPager(context, attrs);
        this.mViewPager.setSaveEnabled(false);
        this.addView((View)this.mViewPager);
        if (attrs != null) {
            // empty if block
        }
    }

    public void setAdapter(SwankyAdapter adapter) {
        this.mAdapter = adapter;
        this.mViewPager.setAdapter(this.mAdapter);
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        this.mViewPager.setCurrentItem(item, smoothScroll);
    }

    public void setMaxZoom(float maxZoom) {
        this.mMaxZoom = maxZoom;
    }

    public void setOffscreenPageLimit(int limit) {
        this.mViewPager.setOffscreenPageLimit(limit);
    }

    public void setOnGalleryPageSelectedListener(OnGalleryPageSelectedListener listener) {
        this.mPageSelectedListener = listener;
    }

    public void setLowSampleSize(int sampleSize) {
        if (sampleSize < SwankyGallery.HI_RES_OPTIONS.inSampleSize) {
            throw new IllegalArgumentException("Low-res sample size may not be less than high-res");
        }
        SwankyGallery.LO_RES_OPTIONS.inSampleSize = sampleSize;
    }

    public void setHighSampleSize(int sampleSize) {
        if (sampleSize > SwankyGallery.LO_RES_OPTIONS.inSampleSize) {
            throw new IllegalArgumentException("High-res sample size may not be greater than low-res");
        }
        SwankyGallery.HI_RES_OPTIONS.inSampleSize = sampleSize;
    }

    public final boolean onInterceptTouchEvent(MotionEvent event) {
        return true;
    }

    public final boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction() & 0xFF;
        SwankyImageView currentView = this.mViewPager.getCurrentView();
        switch (action) {
            case 0: {
                this.mViewPager.onInterceptTouchEvent(event);
                this.mViewPager.onTouchEvent(event);
                currentView.onTouchEvent(event);
                break;
            }
            case 5: {
                currentView.onTouchEvent(event);
                break;
            }
            case 6: {
                currentView.onTouchEvent(event);
                break;
            }
            case 2: {
                if (event.getPointerCount() > 1) {
                    currentView.onTouchEvent(event);
                    break;
                }
                if (currentView.getCurrentScale() == 1.0f) {
                    this.mViewPager.onTouchEvent(event);
                    break;
                }
                this.mViewPager.getCurrentView().onTouchEvent(event);
                if (!(this.xPosPrev < event.getX() && !this.mViewPager.getCurrentView().canScrollLeft()) && (!(this.xPosPrev > event.getX()) || this.mViewPager.getCurrentView().canScrollRight())) break;
                this.mViewPager.onTouchEvent(event);
                break;
            }
            default: {
                this.mViewPager.onTouchEvent(event);
                this.mViewPager.getCurrentView().onTouchEvent(event);
            }
        }
        this.xPosPrev = event.getX();
        return true;
    }

    static {
        SwankyGallery.LO_RES_OPTIONS.inSampleSize = 2;
        SwankyGallery.HI_RES_OPTIONS.inSampleSize = 1;
    }

    public static interface OnGalleryPageSelectedListener {
        public void onPageSelected(int var1);
    }

    private class SwankyViewPager
    extends ViewPager {
        private int currentItem;
        private final ViewPager.SimpleOnPageChangeListener pageChangeListener;

        public SwankyViewPager(Context context) {
            super(context);
            this.currentItem = 0;
            this.pageChangeListener = new ViewPager.SimpleOnPageChangeListener(){

                public void onPageSelected(int i) {
                    View prev = SwankyViewPager.this.findViewWithTag(SwankyViewPager.this.currentItem);
                    if (prev != null && ((SwankyImageView)prev).getCurrentScale() > 1.0f) {
                        ((SwankyImageView)prev).resetScale();
                    }
                    SwankyViewPager.this.currentItem = i;
                    if (SwankyGallery.this.mPageSelectedListener != null) {
                        SwankyGallery.this.mPageSelectedListener.onPageSelected(i);
                    }
                }
            };
            this.setOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageChangeListener);
        }

        public SwankyViewPager(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.currentItem = 0;
            this.pageChangeListener = new /* invalid duplicate definition of identical inner class */;
            this.setOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageChangeListener);
        }

        protected void onPageScrolled(int position, float offset, int offsetPixels) {
            super.onPageScrolled(position, offset, offsetPixels);
            Log.d((String)"SWANK", (String)("page scrolled: " + offsetPixels));
        }

        public final SwankyImageView getCurrentView() {
            return (SwankyImageView)this.findViewWithTag(this.getCurrentItem());
        }
    }

    public static class SwankyAdapter
    extends PagerAdapter {
        private Context mContext;
        private int[] mIds;

        public SwankyAdapter(Context context, int[] imageIds) {
            this.mContext = context;
            this.mIds = imageIds;
        }

        public SwankyImageView instantiateItem(ViewGroup container, int position) {
            SwankyImageView img = new SwankyImageView(this.mContext);
            img.setImageBitmap(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)this.mIds[position], (BitmapFactory.Options)HI_RES_OPTIONS));
            container.addView((View)img);
            img.setTag(position);
            return img;
        }

        public int getCount() {
            return this.mIds.length;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }
    }
}

