/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewConfiguration;

public class BeastViewPager
extends ViewPager {
    private float mCurrX = 0.0f;
    private float mCurrY = 0.0f;
    private int mTouchSlop;

    public BeastViewPager(Context context) {
        super(context);
        this.init();
    }

    public BeastViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.mCurrX = event.getX();
            this.mCurrY = event.getY();
            this.getParent().requestDisallowInterceptTouchEvent(true);
        } else if (action != 2) {
            if (action == 1 || action == 3) {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            } else {
                this.getParent().requestDisallowInterceptTouchEvent(true);
            }
        }
        return super.onInterceptTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action != 0 && action == 2) {
            if (this.getCurrentItem() == 0 && event.getX() - this.mCurrX > (float)this.mTouchSlop) {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            } else if (this.getCurrentItem() == this.getAdapter().getCount() - 1 && this.mCurrX - event.getX() > (float)this.mTouchSlop) {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            } else if (Math.abs(event.getY() - this.mCurrY) > Math.abs(event.getX() - this.mCurrX)) {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        return super.onTouchEvent(event);
    }
}

