/*
 * Decompiled with CFR 0.152.
 */
package oak.util;

import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.http.protocol.HttpContext;

public class CurlRequestInterceptor
implements HttpRequestInterceptor {
    public static String TAG = CurlRequestInterceptor.class.getSimpleName();
    private String authUserName;
    private String additionalCommands;

    public void setAuthUserName(String authUserName) {
        this.authUserName = authUserName;
    }

    public void setAdditionalCommands(String additionalCommands) {
        this.additionalCommands = additionalCommands;
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        StringBuilder sb = new StringBuilder();
        HttpHost targetHost = (HttpHost)httpContext.getAttribute("http.target_host");
        sb.append("curl ");
        if (httpRequest.getRequestLine().getMethod().equals("POST")) {
            try {
                String content = CurlRequestInterceptor.getStringFromIps(((EntityEnclosingRequestWrapper)httpRequest).getEntity().getContent());
                sb.append("-d \"");
                sb.append(content);
                sb.append("\" ");
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Unable to log full content of POST");
                e.printStackTrace();
            }
        }
        sb.append("-k ");
        if (this.authUserName != null) {
            sb.append("-u ");
            sb.append(this.authUserName);
        }
        for (Header h : httpRequest.getAllHeaders()) {
            sb.append(String.format(" -H \"%s:%s\" ", h.getName(), h.getValue()));
        }
        sb.append("\"");
        sb.append(targetHost.toURI());
        sb.append(httpRequest.getRequestLine().getUri());
        sb.append("\"");
        if (this.additionalCommands != null) {
            sb.append(this.additionalCommands);
        }
        Log.d((String)TAG, (String)sb.toString());
    }

    private static String getStringFromIps(InputStream ips) throws IOException {
        String s;
        BufferedReader buf = new BufferedReader(new InputStreamReader(ips, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        while ((s = buf.readLine()) != null) {
            sb.append(s);
        }
        buf.close();
        ips.close();
        return sb.toString();
    }
}

