/*
 * Decompiled with CFR 0.152.
 */
package oak.http;

import android.app.Application;
import android.content.pm.PackageManager;
import android.util.Log;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.integralblue.httpresponsecache.HttpResponseCache;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import oak.Base64;
import oak.http.OakConnection;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import roboguice.util.Ln;

@Singleton
public class OakHttpTool {
    private static final String TAG = OakHttpTool.class.getName();
    Application mApplication;
    Map<String, String> mDefaultHeaders = new HashMap<String, String>();
    Map<String, String> mCredentialsMap = new HashMap<String, String>();
    private boolean mReportVersion = true;
    private static final String ANDROID_VERSION_NAME = "AndroidVersionName";
    private static final String ANDROID_VERSION_CODE = "AndroidVersionCode";
    private String appVersionName;
    private int appVersionCode;

    @Inject
    public OakHttpTool(Application application) {
        this.mApplication = application;
        this.installCache();
        try {
            this.appVersionName = this.mApplication.getPackageManager().getPackageInfo((String)this.mApplication.getPackageName(), (int)0).versionName;
            this.appVersionCode = this.mApplication.getPackageManager().getPackageInfo((String)this.mApplication.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"There was an error setting the version for the app");
        }
    }

    protected void installCache() {
        long httpCacheSize = 0xA00000L;
        File httpCacheDir = new File(this.mApplication.getCacheDir(), "http");
        try {
            HttpResponseCache.install((File)httpCacheDir, (long)0xA00000L);
            Log.i((String)TAG, (String)"cache set up properly");
        }
        catch (IOException e) {
            Ln.e((Throwable)e, (Object)"Failed to set up com.integralblue.httpresponsecache.HttpResponseCache", (Object[])new Object[0]);
        }
    }

    public void setDefaultHeaders(Map<String, String> defaultHeaders) {
        this.mDefaultHeaders = defaultHeaders;
    }

    public Map<String, String> getDefaultHeaders() {
        return this.mDefaultHeaders;
    }

    public void setPreEmptiveBasicAuth(String targetHost, String username, String password) {
        if (targetHost == null || username == null || password == null) {
            throw new RuntimeException("Please supply targethost, username, and password credentials");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(username);
        sb.append(":");
        sb.append(password);
        String encodedBasicAuth = new String(Base64.encode(sb.toString().getBytes(), 2));
        this.mCredentialsMap.put(targetHost, encodedBasicAuth);
    }

    public String getAppVersionName() {
        return this.appVersionName;
    }

    public int getAppVersionCode() {
        return this.appVersionCode;
    }

    public void setReportAppVersion(boolean mReportVersion) {
        this.mReportVersion = mReportVersion;
    }

    private void configureDefaults(URLConnection urlConnection) {
        for (String host : this.mCredentialsMap.keySet()) {
            if (!host.equalsIgnoreCase(urlConnection.getURL().getHost())) continue;
            urlConnection.setRequestProperty("Authorization", "Basic " + this.mCredentialsMap.get(host));
        }
        for (String key : this.mDefaultHeaders.keySet()) {
            urlConnection.setRequestProperty(key, this.mDefaultHeaders.get(key));
        }
        if (this.mReportVersion) {
            urlConnection.setRequestProperty(ANDROID_VERSION_NAME, this.appVersionName);
            urlConnection.setRequestProperty(ANDROID_VERSION_CODE, String.valueOf(this.appVersionCode));
        }
    }

    public OakConnection get(String url) throws IOException {
        URL typedUrl = new URL(url);
        HttpURLConnection httpURLConnection = (HttpURLConnection)typedUrl.openConnection();
        this.configureDefaults(httpURLConnection);
        httpURLConnection.setRequestMethod("GET");
        return new OakConnection(httpURLConnection);
    }

    public OakConnection post(String url, List<BasicNameValuePair> params) throws IOException {
        URL typedUrl = new URL(url);
        HttpURLConnection connection = url.startsWith("https") ? (HttpsURLConnection)typedUrl.openConnection() : (HttpURLConnection)typedUrl.openConnection();
        connection.setReadTimeout(8000);
        connection.setConnectTimeout(8000);
        this.configureDefaults(connection);
        connection.setRequestMethod("POST");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params);
        OutputStream out = connection.getOutputStream();
        entity.writeTo(out);
        out.close();
        return new OakConnection(connection);
    }

    public OakConnection post(String url, StringEntity json) throws IOException {
        URL typedUrl = new URL(url);
        HttpURLConnection connection = url.startsWith("https") ? (HttpsURLConnection)typedUrl.openConnection() : (HttpURLConnection)typedUrl.openConnection();
        connection.setReadTimeout(8000);
        connection.setConnectTimeout(8000);
        this.configureDefaults(connection);
        connection.setRequestMethod("POST");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        OutputStream out = connection.getOutputStream();
        json.writeTo(out);
        out.close();
        return new OakConnection(connection);
    }

    public void setCertValidationDisabled(boolean isDisabled) {
        if (isDisabled) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            catch (Exception e) {
                Ln.e((Throwable)e);
            }
            X509HostnameVerifier allHostsValid = new X509HostnameVerifier(){

                public void verify(String s, SSLSocket sslSocket) throws IOException {
                }

                public void verify(String s, X509Certificate x509Certificate) throws SSLException {
                }

                public void verify(String s, String[] strings, String[] strings1) throws SSLException {
                }

                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)allHostsValid);
        }
    }

    public void trustEveryone() {
        try {
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new X509TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetCache() {
        try {
            HttpResponseCache installed = HttpResponseCache.getInstalled();
            installed.delete();
            this.installCache();
        }
        catch (IOException e) {
            Ln.e((Throwable)e);
        }
    }
}

