/*
 * Decompiled with CFR 0.152.
 */
package oak.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.zip.GZIPInputStream;
import oak.http.exception.AuthenticationException;
import oak.http.exception.OakHttpException;

public class OakConnection {
    private HttpURLConnection mHttpUrlConnection;
    private boolean mPrintToLog;

    public OakConnection(HttpURLConnection httpURLConnection) {
        this.mHttpUrlConnection = httpURLConnection;
    }

    public HttpURLConnection getHttpURLConnection() {
        return this.mHttpUrlConnection;
    }

    public BufferedReader getBufferedResponseReader() throws IOException {
        return new BufferedReader(new InputStreamReader(this.getInputStream()));
    }

    public InputStream getInputStream() throws IOException {
        try {
            InputStream is = this.mHttpUrlConnection.getInputStream();
            if ("gzip".equals(this.mHttpUrlConnection.getContentEncoding())) {
                is = new GZIPInputStream(is);
            }
            return is;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.mHttpUrlConnection.disconnect();
            int responseCode = this.mHttpUrlConnection.getResponseCode();
            switch (responseCode) {
                case 401: {
                    throw new AuthenticationException();
                }
            }
            throw new OakHttpException(responseCode);
        }
    }

    public OakConnection printResponseToLog(boolean printToLog) {
        this.mPrintToLog = printToLog;
        return this;
    }

    public OakConnection withCache(long cacheTimeoutSeconds) {
        if (cacheTimeoutSeconds <= 0L) {
            int maxStale = 2419200;
            this.mHttpUrlConnection.setRequestProperty("Cache-Control", "max-stale=" + maxStale);
        } else {
            this.mHttpUrlConnection.setRequestProperty("Cache-Control", "max-age=" + cacheTimeoutSeconds);
        }
        return this;
    }

    public OakConnection followRedirects(boolean followRedirects) {
        this.mHttpUrlConnection.setInstanceFollowRedirects(followRedirects);
        return this;
    }

    public void disconnect() {
        this.mHttpUrlConnection.disconnect();
    }
}

