/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.support;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import java.io.File;
import java.util.List;
import java.util.Locale;

public class IntentSupport {
    public static final String MIME_TYPE_EMAIL = "message/rfc822";
    public static final String MIME_TYPE_TEXT = "text/*";

    public static boolean isIntentAvailable(Context context, String action, Uri uri, String mimeType) {
        List list;
        Intent intent;
        Intent intent2 = intent = uri != null ? new Intent(action, uri) : new Intent(action);
        if (mimeType != null) {
            intent.setType(mimeType);
        }
        return !(list = context.getPackageManager().queryIntentActivities(intent, 65536)).isEmpty();
    }

    public static boolean isIntentAvailable(Context context, String action, String mimeType) {
        List list;
        Intent intent = new Intent(action);
        if (mimeType != null) {
            intent.setType(mimeType);
        }
        return !(list = context.getPackageManager().queryIntentActivities(intent, 65536)).isEmpty();
    }

    public static boolean isIntentAvailable(Context context, Intent intent) {
        List list = context.getPackageManager().queryIntentActivities(intent, 65536);
        return !list.isEmpty();
    }

    public static Intent newEmailIntent(Context context, String address, String subject, String body) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.EMAIL", new String[]{address});
        intent.putExtra("android.intent.extra.TEXT", body);
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.setType(MIME_TYPE_EMAIL);
        return intent;
    }

    public static Intent newShareIntent(Context context, String subject, String message, String chooserDialogTitle) {
        Intent shareIntent = new Intent("android.intent.action.SEND");
        shareIntent.putExtra("android.intent.extra.TEXT", message);
        shareIntent.putExtra("android.intent.extra.SUBJECT", subject);
        shareIntent.setType(MIME_TYPE_TEXT);
        return Intent.createChooser((Intent)shareIntent, (CharSequence)chooserDialogTitle);
    }

    public static Intent newMapsIntent(String address, String placeTitle) {
        StringBuilder sb = new StringBuilder();
        sb.append("geo:0,0?q=");
        String addressEncoded = Uri.encode((String)address);
        sb.append(addressEncoded);
        String titleEncoded = Uri.encode((String)("(" + placeTitle + ")"));
        sb.append(titleEncoded);
        sb.append("&hl=" + Locale.getDefault().getLanguage());
        return new Intent("android.intent.action.VIEW", Uri.parse((String)sb.toString()));
    }

    public static Intent newTakePictureIntent(File tempFile) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)tempFile));
        return intent;
    }

    public static Intent newSelectPictureIntent() {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setType("image/*");
        return intent;
    }

    public static Intent newDialNumberIntent(String phoneNumber) {
        return new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + phoneNumber.replace(" ", ""))));
    }

    public static Intent newCallNumberIntent(String phoneNumber) {
        return new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + phoneNumber.replace(" ", ""))));
    }
}

