/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.support;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;

public class DisplaySupport {
    public static final int SCREEN_DENSITY_LOW = 120;
    public static final int SCREEN_DENSITY_MEDIUM = 160;
    public static final int SCREEN_DENSITY_HIGH = 240;
    private static int screenDensity = -1;

    public static int dipToPx(Context context, int dip) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)((float)dip * displayMetrics.density + 0.5f);
    }

    public static Drawable scaleDrawable(Context context, int drawableResourceId, int width, int height) {
        Bitmap sourceBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)drawableResourceId);
        return new BitmapDrawable(Bitmap.createScaledBitmap((Bitmap)sourceBitmap, (int)width, (int)height, (boolean)true));
    }

    public static int getScreenDensity(Context context) {
        if (screenDensity == -1) {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            try {
                screenDensity = DisplayMetrics.class.getField("densityDpi").getInt(displayMetrics);
            }
            catch (Exception e) {
                screenDensity = 160;
            }
        }
        return screenDensity;
    }
}

