/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Log;
import android.widget.ImageView;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import oak.external.com.github.droidfu.cachefu.ImageCache;
import oak.external.com.github.droidfu.imageloader.ImageLoaderHandler;

public class ImageLoader
implements Runnable {
    public static final int HANDLER_MESSAGE_ID = 0;
    public static final String BITMAP_EXTRA = "droidfu:extra_bitmap";
    public static final String IMAGE_URL_EXTRA = "droidfu:extra_image_url";
    private static final String LOG_TAG = "Droid-Fu/ImageLoader";
    protected static final int DEFAULT_POOL_SIZE = 3;
    private static final int DEFAULT_TTL_MINUTES = 1440;
    protected static final int DEFAULT_RETRY_HANDLER_SLEEP_TIME = 1000;
    private static final int DEFAULT_NUM_RETRIES = 3;
    protected static ThreadPoolExecutor executor;
    protected static ImageCache imageCache;
    protected static int numRetries;
    protected static long expirationInMinutes;
    private String imageUrl;
    private ImageLoaderHandler handler;

    public static void setThreadPoolSize(int numThreads) {
        executor.setMaximumPoolSize(numThreads);
    }

    public static void setMaxDownloadAttempts(int numAttempts) {
        numRetries = numAttempts;
    }

    public static synchronized void initialize(Context context) {
        if (executor == null) {
            executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(3);
        }
        if (imageCache == null) {
            imageCache = new ImageCache(25, expirationInMinutes, 3);
            imageCache.enableDiskCache(context, 1);
        }
    }

    public static synchronized void initialize(Context context, long expirationInMinutes) {
        ImageLoader.expirationInMinutes = expirationInMinutes;
        ImageLoader.initialize(context);
    }

    protected ImageLoader(String imageUrl, ImageLoaderHandler handler) {
        this.imageUrl = imageUrl;
        this.handler = handler;
    }

    public static void start(String imageUrl, ImageView imageView) {
        ImageLoader.start(imageUrl, imageView, new ImageLoaderHandler(imageView, imageUrl), null, null);
    }

    public static void start(String imageUrl, ImageView imageView, Drawable dummyDrawable, Drawable errorDrawable) {
        ImageLoader.start(imageUrl, imageView, new ImageLoaderHandler(imageView, imageUrl, errorDrawable), dummyDrawable, errorDrawable);
    }

    public static void start(String imageUrl, ImageLoaderHandler handler) {
        ImageLoader.start(imageUrl, handler.getImageView(), handler, null, null);
    }

    public static void start(String imageUrl, ImageLoaderHandler handler, Drawable dummyDrawable, Drawable errorDrawable) {
        ImageLoader.start(imageUrl, handler.getImageView(), handler, dummyDrawable, errorDrawable);
    }

    private static void start(String imageUrl, ImageView imageView, ImageLoaderHandler handler, Drawable dummyDrawable, Drawable errorDrawable) {
        if (imageView != null) {
            if (imageUrl == null) {
                imageView.setTag(null);
                imageView.setImageDrawable(dummyDrawable);
                return;
            }
            String oldImageUrl = (String)imageView.getTag();
            if (imageUrl.equals(oldImageUrl)) {
                return;
            }
            imageView.setImageDrawable(dummyDrawable);
            imageView.setTag((Object)imageUrl);
        }
        if (imageCache.containsKeyInMemory(imageUrl)) {
            handler.handleImageLoaded(imageCache.getBitmap(imageUrl), null);
        } else {
            executor.execute(new ImageLoader(imageUrl, handler));
        }
    }

    public static void clearCache() {
        imageCache.clear();
    }

    public static ImageCache getImageCache() {
        return imageCache;
    }

    @Override
    public void run() {
        Bitmap bitmap = imageCache.getBitmap(this.imageUrl);
        if (bitmap == null) {
            bitmap = this.downloadImage();
        }
        this.notifyImageLoaded(this.imageUrl, bitmap);
    }

    protected Bitmap downloadImage() {
        for (int timesTried = 1; timesTried <= numRetries; ++timesTried) {
            try {
                byte[] imageData = this.retrieveImageData();
                if (imageData != null) {
                    imageCache.put(this.imageUrl, imageData);
                    return BitmapFactory.decodeByteArray((byte[])imageData, (int)0, (int)imageData.length);
                }
                break;
            }
            catch (Throwable e) {
                Log.w((String)LOG_TAG, (String)("download for " + this.imageUrl + " failed (attempt " + timesTried + ")"));
                e.printStackTrace();
                SystemClock.sleep((long)1000L);
                continue;
            }
        }
        return null;
    }

    protected byte[] retrieveImageData() throws IOException {
        byte[] result;
        URL url = new URL(this.imageUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        int fileSize = connection.getContentLength();
        Log.d((String)LOG_TAG, (String)("fetching image " + this.imageUrl + " (" + fileSize + ")"));
        BufferedInputStream istream = new BufferedInputStream(connection.getInputStream());
        if (fileSize > -1) {
            byte[] imageData = new byte[fileSize];
            int bytesRead = 0;
            for (int offset = 0; bytesRead != -1 && offset < fileSize; offset += bytesRead) {
                bytesRead = istream.read(imageData, offset, fileSize - offset);
            }
            result = imageData;
        } else {
            int bytesRead;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = istream.read(buffer)) > 0) {
                baos.write(buffer, 0, bytesRead);
            }
            result = baos.toByteArray();
        }
        istream.close();
        connection.disconnect();
        return result;
    }

    public void notifyImageLoaded(String url, Bitmap bitmap) {
        Message message = new Message();
        message.what = 0;
        Bundle data = new Bundle();
        data.putString(IMAGE_URL_EXTRA, url);
        Bitmap image = bitmap;
        data.putParcelable(BITMAP_EXTRA, (Parcelable)image);
        message.setData(data);
        this.handler.sendMessage(message);
    }

    static {
        numRetries = 3;
        expirationInMinutes = 1440L;
    }
}

