/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.http;

import java.io.IOException;
import java.io.InputStream;
import oak.external.com.github.droidfu.http.BetterHttpResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;

public class BetterHttpResponseImpl
implements BetterHttpResponse {
    private HttpResponse response;
    private HttpEntity entity;

    public BetterHttpResponseImpl(HttpResponse response) throws IOException {
        this.response = response;
        HttpEntity temp = response.getEntity();
        if (temp != null) {
            this.entity = new BufferedHttpEntity(temp);
        }
    }

    @Override
    public HttpResponse unwrap() {
        return this.response;
    }

    @Override
    public InputStream getResponseBody() throws IOException {
        return this.entity.getContent();
    }

    @Override
    public byte[] getResponseBodyAsBytes() throws IOException {
        return EntityUtils.toByteArray((HttpEntity)this.entity);
    }

    @Override
    public String getResponseBodyAsString() throws IOException {
        return EntityUtils.toString((HttpEntity)this.entity);
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public String getHeader(String header) {
        if (!this.response.containsHeader(header)) {
            return null;
        }
        return this.response.getFirstHeader(header).getValue();
    }
}

