/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.http;

import android.util.Log;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oak.external.com.github.droidfu.cachefu.HttpResponseCache;
import oak.external.com.github.droidfu.http.BetterHttp;
import oak.external.com.github.droidfu.http.BetterHttpRequest;
import oak.external.com.github.droidfu.http.BetterHttpRequestRetryHandler;
import oak.external.com.github.droidfu.http.BetterHttpResponse;
import oak.external.com.github.droidfu.http.BetterHttpResponseImpl;
import oak.external.com.github.droidfu.http.CachedHttpResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public abstract class BetterHttpRequestBase
implements BetterHttpRequest,
ResponseHandler<BetterHttpResponse> {
    private static final int MAX_RETRIES = 5;
    protected static final String HTTP_CONTENT_TYPE_HEADER = "Content-Type";
    protected List<Integer> expectedStatusCodes = new ArrayList<Integer>();
    protected AbstractHttpClient httpClient;
    protected HttpUriRequest request;
    protected int maxRetries = 5;
    private int oldTimeout;
    private int executionCount;

    BetterHttpRequestBase(AbstractHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public HttpUriRequest unwrap() {
        return this.request;
    }

    @Override
    public String getRequestUrl() {
        return this.request.getURI().toString();
    }

    @Override
    public BetterHttpRequestBase expecting(Integer ... statusCodes) {
        this.expectedStatusCodes = Arrays.asList(statusCodes);
        return this;
    }

    @Override
    public BetterHttpRequestBase retries(int retries) {
        this.maxRetries = retries < 0 ? 0 : (retries > 5 ? 5 : retries);
        return this;
    }

    @Override
    public BetterHttpRequest withTimeout(int timeout) {
        this.oldTimeout = this.httpClient.getParams().getIntParameter("http.socket.timeout", 30000);
        BetterHttp.setSocketTimeout(timeout);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BetterHttpResponse send() throws ConnectException {
        BetterHttpRequestRetryHandler retryHandler = new BetterHttpRequestRetryHandler(this.maxRetries);
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)retryHandler);
        BasicHttpContext context = new BasicHttpContext();
        boolean retry = true;
        IOException cause = null;
        while (retry) {
            try {
                BetterHttpResponse betterHttpResponse = (BetterHttpResponse)this.httpClient.execute(this.request, (ResponseHandler)this, (HttpContext)context);
                return betterHttpResponse;
            }
            catch (IOException e) {
                cause = e;
                retry = this.retryRequest(retryHandler, cause, (HttpContext)context);
            }
            catch (NullPointerException e) {
                cause = new IOException("NPE in HttpClient" + e.getMessage());
                retry = this.retryRequest(retryHandler, cause, (HttpContext)context);
            }
            finally {
                if (this.oldTimeout == BetterHttp.getSocketTimeout()) continue;
                BetterHttp.setSocketTimeout(this.oldTimeout);
            }
        }
        ConnectException ex = new ConnectException();
        ex.initCause(cause);
        throw ex;
    }

    private boolean retryRequest(BetterHttpRequestRetryHandler retryHandler, IOException cause, HttpContext context) {
        Log.e((String)"BetterHttp", (String)"Intercepting exception that wasn't handled by HttpClient");
        this.executionCount = Math.max(this.executionCount, retryHandler.getTimesRetried());
        return retryHandler.retryRequest(cause, ++this.executionCount, context);
    }

    public BetterHttpResponse handleResponse(HttpResponse response) throws IOException {
        int status = response.getStatusLine().getStatusCode();
        if (this.expectedStatusCodes != null && !this.expectedStatusCodes.isEmpty() && !this.expectedStatusCodes.contains(status)) {
            throw new HttpResponseException(status, "Unexpected status code: " + status);
        }
        BetterHttpResponseImpl bhttpr = new BetterHttpResponseImpl(response);
        HttpResponseCache responseCache = BetterHttp.getResponseCache();
        if (responseCache != null) {
            CachedHttpResponse.ResponseData responseData = new CachedHttpResponse.ResponseData(status, bhttpr.getResponseBodyAsBytes());
            responseCache.put(this.getRequestUrl(), responseData);
        }
        return bhttpr;
    }
}

