/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.cachefu;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Set;
import oak.external.com.github.droidfu.cachefu.AbstractCache;

public class CacheHelper {
    public static String getFileNameFromUrl(String url) {
        return url.replaceAll("[.:/,%?&=]", "+").replaceAll("[+]+", "+");
    }

    public static void removeAllWithStringPrefix(AbstractCache<String, ?> cache, String urlPrefix) {
        Set<String> keys = cache.keySet();
        for (String key : keys) {
            if (!key.startsWith(urlPrefix)) continue;
            cache.remove(key);
        }
        if (cache.isDiskCacheEnabled()) {
            CacheHelper.removeExpiredCache(cache, urlPrefix);
        }
    }

    private static void removeExpiredCache(final AbstractCache<String, ?> cache, final String urlPrefix) {
        final File cacheDir = new File(cache.getDiskCacheDirectory());
        if (!cacheDir.exists()) {
            return;
        }
        File[] list = cacheDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return dir.equals(cacheDir) && filename.startsWith(cache.getFileNameForKey(urlPrefix));
            }
        });
        if (list == null || list.length == 0) {
            return;
        }
        for (File file : list) {
            file.delete();
        }
    }
}

