/*
 * Decompiled with CFR 0.152.
 */
package oak;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Debug;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import oak.external.com.github.droidfu.cachefu.ImageCache;

public class OAKImageCache
extends ImageCache {
    public static final String LOG_TAG = OAKImageCache.class.getSimpleName();
    private HashMap<String, Long> fileAges = new HashMap();
    private int cacheLimit = 0x800000;
    private volatile int cacheAllocated = 0;
    private Context context;
    private int[] pid;
    private ActivityManager am;
    private boolean safeMode;
    private int bytesPerPixel = 4;

    public OAKImageCache(int initialCapacity, long expirationInMinutes, int maxConcurrentThreads) {
        super(initialCapacity, expirationInMinutes, maxConcurrentThreads);
    }

    @Override
    public synchronized Bitmap getBitmap(Object elementKey) {
        byte[] imageData = (byte[])super.get(elementKey);
        if (imageData == null) {
            return null;
        }
        if (this.safeMode) {
            int memPerProcess = this.am.getMemoryClass() * 1024 * 1024;
            Debug.MemoryInfo mi = this.am.getProcessMemoryInfo(this.pid)[0];
            int usedMem = mi.getTotalPrivateDirty() + mi.getTotalSharedDirty();
            Log.d((String)"OAKImageCache", (String)("MemPerProcess: " + memPerProcess));
            Log.d((String)"OAKImageCache", (String)("usedMem: " + usedMem));
            Log.d((String)"OAKImageCache", (String)("imgSize: " + this.getImageArea(imageData) * this.bytesPerPixel));
            if (usedMem + this.getImageArea(imageData) * this.bytesPerPixel > memPerProcess) {
                return null;
            }
        }
        return BitmapFactory.decodeByteArray((byte[])imageData, (int)0, (int)imageData.length);
    }

    @Override
    public synchronized byte[] put(String imageUrl, byte[] data) {
        this.fileAges.put(imageUrl, new Date().getTime());
        while (this.cacheAllocated + data.length > this.cacheLimit) {
            this.deleteOldestImage();
        }
        byte[] result = super.put(imageUrl, data);
        return result;
    }

    public synchronized void putToDisk(String imageUrl, byte[] data) {
        this.fileAges.put(imageUrl, new Date().getTime());
        while (this.cacheAllocated + data.length > this.cacheLimit) {
            this.deleteOldestImage();
        }
        super.cacheToDisk(imageUrl, data);
    }

    public int getCacheAllocated() {
        return this.cacheAllocated;
    }

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    public void setCacheLimit(int newLimit) {
        this.cacheLimit = newLimit;
    }

    public void updateContents() {
        String cacheDir = this.getDiskCacheDirectory();
        if (cacheDir != null) {
            File[] cachedFiles = new File(cacheDir).listFiles();
            if (cachedFiles == null) {
                this.cacheAllocated = 0;
            } else {
                for (File f : cachedFiles) {
                    this.cacheAllocated = (int)((long)this.cacheAllocated + f.length());
                    this.fileAges.put(f.getName(), f.lastModified());
                }
            }
            Log.i((String)LOG_TAG, (String)("Allocated cache at startup: " + this.cacheAllocated + " bytes."));
        }
    }

    private void deleteOldestImage() {
        long oldestAge = 0L;
        String oldestUrl = null;
        for (String url : this.fileAges.keySet()) {
            Long currAge = this.fileAges.get(url);
            if (currAge <= oldestAge) continue;
            oldestAge = currAge;
            oldestUrl = url;
        }
        if (oldestUrl != null) {
            this.fileAges.remove(oldestUrl);
            this.cacheAllocated = (int)((long)this.cacheAllocated - new File(this.getFileNameForKey(oldestUrl)).length());
            this.remove(oldestUrl);
        }
    }

    @Override
    protected void cacheToDisk(String key, byte[] value) {
        super.cacheToDisk(key, value);
    }

    protected int getImageArea(byte[] data) {
        if (data[0] == -1 && data[1] == -40) {
            try {
                return this.getJPEGArea(data);
            }
            catch (Exception e) {
                return -1;
            }
        }
        if (data[0] == -119 && data[1] == 80 && data[2] == 78 && data[3] == 71) {
            int idx = 0;
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != 73 || data[i + 1] != 72 || data[i + 2] != 68 || data[i + 3] != 82) continue;
                idx = i;
                break;
            }
            int width = (data[idx += 4] << 24) + (data[idx + 1] << 16) + (data[idx + 2] << 8) + data[idx + 3];
            int height = (data[idx + 4] << 24) + (data[idx + 5] << 16) + (data[idx + 6] << 8) + data[idx + 7];
            return width * height;
        }
        if (data[0] == 71 && data[1] == 73 && data[2] == 70 && data[3] == 56) {
            int wIdx = 6;
            int hIdx = 8;
            int width = ((data[wIdx + 1] & 0xFF) << 8) + (data[wIdx] & 0xFF);
            int height = ((data[hIdx + 1] & 0xFF) << 8) + data[hIdx];
            return width * height;
        }
        if (data[0] == 66 && data[1] == 77) {
            return data.length;
        }
        return -1;
    }

    private int getJPEGArea(byte[] data) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        if (((InputStream)bis).read() != 255 || ((InputStream)bis).read() != 216) {
            throw new RuntimeException("SOI (Start Of Image) marker 0xff 0xd8 missing");
        }
        while (((InputStream)bis).read() == 255) {
            int marker = ((InputStream)bis).read();
            int len = ((InputStream)bis).read() << 8 | ((InputStream)bis).read();
            if (marker == 192) {
                ((InputStream)bis).skip(1L);
                int height = ((InputStream)bis).read() << 8 | ((InputStream)bis).read();
                int width = ((InputStream)bis).read() << 8 | ((InputStream)bis).read();
                ((InputStream)bis).close();
                return width * height;
            }
            ((InputStream)bis).skip(len - 2);
        }
        ((InputStream)bis).close();
        return -1;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public boolean isSafeMode() {
        return this.safeMode;
    }

    public void setSafeMode(boolean safeMode) {
        this.safeMode = safeMode;
    }
}

