/*
 * Decompiled with CFR 0.152.
 */
package oak;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;

public class MultiDirectionSlidingDrawer
extends ViewGroup {
    public static final int ORIENTATION_RTL = 0;
    public static final int ORIENTATION_BTT = 1;
    public static final int ORIENTATION_LTR = 2;
    public static final int ORIENTATION_TTB = 3;
    private static final int TAP_THRESHOLD = 6;
    private static final float MAXIMUM_TAP_VELOCITY = 100.0f;
    private static final float MAXIMUM_MINOR_VELOCITY = 150.0f;
    private static final float MAXIMUM_MAJOR_VELOCITY = 200.0f;
    private static final float MAXIMUM_ACCELERATION = 2000.0f;
    private static final int VELOCITY_UNITS = 1000;
    private static final int MSG_ANIMATE = 1000;
    private static final int ANIMATION_FRAME_DURATION = 16;
    private static final int EXPANDED_FULL_OPEN = -10001;
    private static final int COLLAPSED_FULL_CLOSED = -10002;
    private final int mHandleId;
    private final int mContentId;
    private View mHandle;
    private View mContent;
    private final Rect mFrame = new Rect();
    private final Rect mInvalidate = new Rect();
    private boolean mTracking;
    private boolean mLocked;
    private boolean hasTrackedAboveThreshold = false;
    private boolean hasTrackedBelowThreshold = false;
    private VelocityTracker mVelocityTracker;
    private boolean mInvert;
    private boolean mVertical;
    private boolean mExpanded;
    private int mBottomOffset;
    private int mTopOffset;
    private int mHandleHeight;
    private int mHandleWidth;
    private int mTopMargin;
    private OnDrawerOpenListener mOnDrawerOpenListener;
    private OnDrawerCloseListener mOnDrawerCloseListener;
    private OnDrawerScrollListener mOnDrawerScrollListener;
    private OnThresholdHitListener mOnThresholdHitListener;
    private final Handler mHandler = new SlidingHandler();
    private float mAnimatedAcceleration;
    private float mAnimatedVelocity;
    private float mAnimationPosition;
    private long mAnimationLastTime;
    private long mCurrentAnimationTime;
    private int mTouchDelta;
    private boolean mAnimating;
    private boolean mAllowSingleTap;
    private boolean mAnimateOnClick;
    private final int mTapThreshold;
    private final int mMaximumTapVelocity;
    private int mMaximumMinorVelocity;
    private int mMaximumMajorVelocity;
    private int mMaximumAcceleration;
    private final int mVelocityUnits;
    public static final String LOG_TAG = "Sliding";

    public MultiDirectionSlidingDrawer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MultiDirectionSlidingDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        Resources res = this.getResources();
        int orientation = 1;
        String orientationId = attrs.getAttributeValue("http://oak/oak/schema", "direction");
        if (orientationId.equals("rightToLeft")) {
            orientation = 0;
        } else if (orientationId.equals("leftToRight")) {
            orientation = 2;
        } else if (orientationId.equals("topToBottom")) {
            orientation = 3;
        }
        this.mVertical = orientation == 1 || orientation == 3;
        int mBottomOffsetId = attrs.getAttributeResourceValue("http://oak/oak/schema", "bottomOffset", -1);
        this.mBottomOffset = mBottomOffsetId == -1 ? 0 : (int)res.getDimension(mBottomOffsetId);
        int mTopOffsetId = attrs.getAttributeResourceValue("http://oak/oak/schema", "topOffset", -1);
        this.mTopOffset = mTopOffsetId == -1 ? 0 : (int)res.getDimension(mTopOffsetId);
        int mTopMarginId = attrs.getAttributeResourceValue("http://oak/oak/schema", "topMargin", -1);
        this.mTopMargin = mTopMarginId == -1 ? 0 : (int)res.getDimension(mTopMarginId);
        int mAllowSingleTapId = attrs.getAttributeResourceValue("http://oak/oak/schema", "allowSingleTap", -1);
        this.mAllowSingleTap = mAllowSingleTapId == -1 ? true : res.getBoolean(mAllowSingleTapId);
        int mAnimateOnClickId = attrs.getAttributeResourceValue("http://oak/oak/schema", "animateOnClick", -1);
        this.mAnimateOnClick = mAnimateOnClickId == -1 ? true : res.getBoolean(mAllowSingleTapId);
        this.mInvert = orientation == 3 || orientation == 2;
        int handleId = attrs.getAttributeResourceValue("http://oak/oak/schema", "handle", 0);
        if (handleId == 0) {
            throw new IllegalArgumentException("The handle attribute is required and must refer to a valid child.");
        }
        int contentId = attrs.getAttributeResourceValue("http://oak/oak/schema", "content", 0);
        if (contentId == 0) {
            throw new IllegalArgumentException("The content attribute is required and must refer to a valid child.");
        }
        if (handleId == contentId) {
            throw new IllegalArgumentException("The content and handle attributes must refer to different children.");
        }
        this.mHandleId = handleId;
        this.mContentId = contentId;
        float density = this.getResources().getDisplayMetrics().density;
        this.mTapThreshold = (int)(6.0f * density + 0.5f);
        this.mMaximumTapVelocity = (int)(100.0f * density + 0.5f);
        this.mMaximumMinorVelocity = (int)(150.0f * density + 0.5f);
        this.mMaximumMajorVelocity = (int)(200.0f * density + 0.5f);
        this.mMaximumAcceleration = (int)(2000.0f * density + 0.5f);
        this.mVelocityUnits = (int)(1000.0f * density + 0.5f);
        if (this.mInvert) {
            this.mMaximumAcceleration = -this.mMaximumAcceleration;
            this.mMaximumMajorVelocity = -this.mMaximumMajorVelocity;
            this.mMaximumMinorVelocity = -this.mMaximumMinorVelocity;
        }
        this.setAlwaysDrawnWithCacheEnabled(false);
    }

    protected void onFinishInflate() {
        this.mHandle = this.findViewById(this.mHandleId);
        if (this.mHandle == null) {
            throw new IllegalArgumentException("The handle attribute is must refer to an existing child.");
        }
        this.mHandle.setOnClickListener((View.OnClickListener)new DrawerToggler());
        this.mContent = this.findViewById(this.mContentId);
        if (this.mContent == null) {
            throw new IllegalArgumentException("The content attribute is must refer to an existing child.");
        }
        this.mContent.setVisibility(8);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthSpecMode == 0 || heightSpecMode == 0) {
            throw new RuntimeException("SlidingDrawer cannot have UNSPECIFIED dimensions");
        }
        View handle = this.getHandle();
        View content = this.getContent();
        this.measureChild(handle, widthMeasureSpec, heightMeasureSpec);
        if (this.mVertical) {
            int height = heightSpecSize - handle.getMeasuredHeight() - this.mTopOffset;
            content.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)height, (int)heightSpecMode));
            heightSpecSize = handle.getMeasuredHeight() + this.mTopOffset + content.getMeasuredHeight();
            widthSpecSize = content.getMeasuredWidth();
            if (handle.getMeasuredWidth() > widthSpecSize) {
                widthSpecSize = handle.getMeasuredWidth();
            }
        } else {
            int width = widthSpecSize - handle.getMeasuredWidth() - this.mTopOffset;
            this.getContent().measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)widthSpecMode), heightMeasureSpec);
            widthSpecSize = handle.getMeasuredWidth() + this.mTopOffset + content.getMeasuredWidth();
            heightSpecSize = content.getMeasuredHeight();
            if (handle.getMeasuredHeight() > heightSpecSize) {
                heightSpecSize = handle.getMeasuredHeight();
            }
        }
        this.setMeasuredDimension(widthSpecSize, heightSpecSize);
    }

    protected void dispatchDraw(Canvas canvas) {
        long drawingTime = this.getDrawingTime();
        View handle = this.mHandle;
        boolean isVertical = this.mVertical;
        this.drawChild(canvas, handle, drawingTime);
        if (this.mTracking || this.mAnimating) {
            Bitmap cache = this.mContent.getDrawingCache();
            if (cache != null) {
                if (isVertical) {
                    if (this.mInvert) {
                        canvas.drawBitmap(cache, 0.0f, (float)(handle.getTop() - (this.getBottom() - this.getTop()) + this.mHandleHeight), null);
                    } else {
                        canvas.drawBitmap(cache, 0.0f, (float)handle.getBottom(), null);
                    }
                } else {
                    canvas.drawBitmap(cache, this.mInvert ? (float)(handle.getLeft() - cache.getWidth()) : (float)handle.getRight(), 0.0f, null);
                }
            } else {
                canvas.save();
                if (this.mInvert) {
                    canvas.translate(isVertical ? 0.0f : (float)(handle.getLeft() - this.mTopOffset - this.mContent.getMeasuredWidth()), isVertical ? (float)(handle.getTop() - this.mTopOffset - this.mContent.getMeasuredHeight()) : 0.0f);
                } else {
                    canvas.translate(isVertical ? 0.0f : (float)(handle.getLeft() - this.mTopOffset), isVertical ? (float)(handle.getTop() - this.mTopOffset) : 0.0f);
                }
                this.drawChild(canvas, this.mContent, drawingTime);
                canvas.restore();
            }
            this.invalidate();
        } else if (this.mExpanded) {
            this.drawChild(canvas, this.mContent, drawingTime);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int handleTop;
        int handleLeft;
        if (this.mTracking) {
            return;
        }
        int width = r - l;
        int height = b - t;
        View handle = this.mHandle;
        int handleWidth = handle.getMeasuredWidth();
        int handleHeight = handle.getMeasuredHeight();
        Log.d((String)LOG_TAG, (String)("handleHeight: " + handleHeight));
        View content = this.mContent;
        if (this.mVertical) {
            handleLeft = (width - handleWidth) / 2;
            if (this.mInvert) {
                Log.d((String)LOG_TAG, (String)"content.layout(1)");
                handleTop = this.mExpanded ? height - this.mBottomOffset - handleHeight : this.mTopMargin + this.mTopOffset;
                content.layout(0, this.mTopOffset, content.getMeasuredWidth(), this.mTopOffset + content.getMeasuredHeight());
            } else {
                handleTop = this.mExpanded ? this.mTopMargin + this.mTopOffset : height - handleHeight + this.mBottomOffset;
                content.layout(0, this.mTopOffset + handleHeight, content.getMeasuredWidth(), this.mTopOffset + handleHeight + content.getMeasuredHeight());
            }
        } else {
            handleTop = (height - handleHeight) / 2;
            if (this.mInvert) {
                handleLeft = this.mExpanded ? width - this.mBottomOffset - handleWidth : this.mTopMargin + this.mTopOffset;
                content.layout(this.mTopOffset, 0, this.mTopOffset + content.getMeasuredWidth(), content.getMeasuredHeight());
            } else {
                handleLeft = this.mExpanded ? this.mTopMargin + this.mTopOffset : width - handleWidth + this.mBottomOffset;
                content.layout(this.mTopOffset + handleWidth, 0, this.mTopOffset + handleWidth + content.getMeasuredWidth(), content.getMeasuredHeight());
            }
        }
        handle.layout(handleLeft, handleTop, handleLeft + handleWidth, handleTop + handleHeight);
        this.mHandleHeight = handle.getHeight();
        this.mHandleWidth = handle.getWidth();
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.mLocked) {
            return false;
        }
        int action = event.getAction();
        float x = event.getX();
        float y = event.getY();
        Rect frame = this.mFrame;
        View handle = this.mHandle;
        handle.getHitRect(frame);
        if (!this.mTracking && !frame.contains((int)x, (int)y)) {
            return false;
        }
        if (action == 0) {
            this.mTracking = true;
            handle.setPressed(true);
            this.prepareContent();
            if (this.mOnDrawerScrollListener != null) {
                this.mOnDrawerScrollListener.onScrollStarted();
            }
            if (this.mVertical) {
                int top = this.mHandle.getTop();
                this.mTouchDelta = (int)y - top;
                this.prepareTracking(top);
            } else {
                int left = this.mHandle.getLeft();
                this.mTouchDelta = (int)x - left;
                this.prepareTracking(left);
            }
            this.mVelocityTracker.addMovement(event);
        }
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mLocked) {
            return true;
        }
        if (this.mTracking) {
            this.mVelocityTracker.addMovement(event);
            int action = event.getAction();
            switch (action) {
                case 2: {
                    this.moveHandle((int)(this.mVertical ? event.getY() : event.getX()) - this.mTouchDelta);
                    break;
                }
                case 1: 
                case 3: {
                    boolean negative;
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(this.mVelocityUnits);
                    float yVelocity = velocityTracker.getYVelocity();
                    float xVelocity = velocityTracker.getXVelocity();
                    boolean vertical = this.mVertical;
                    if (vertical) {
                        boolean bl = negative = yVelocity < 0.0f;
                        if (xVelocity < 0.0f) {
                            xVelocity = -xVelocity;
                        }
                        if (xVelocity > (float)this.mMaximumMinorVelocity) {
                            xVelocity = this.mMaximumMinorVelocity;
                        }
                    } else {
                        boolean bl = negative = xVelocity < 0.0f;
                        if (yVelocity < 0.0f) {
                            yVelocity = -yVelocity;
                        }
                        if (yVelocity > (float)this.mMaximumMinorVelocity) {
                            yVelocity = this.mMaximumMinorVelocity;
                        }
                    }
                    float velocity = (float)Math.hypot(xVelocity, yVelocity);
                    if (negative) {
                        velocity = -velocity;
                    }
                    int handleTop = this.mHandle.getTop();
                    int handleLeft = this.mHandle.getLeft();
                    int handleBottom = this.mHandle.getBottom();
                    int handleRight = this.mHandle.getRight();
                    if (Math.abs(velocity) < (float)this.mMaximumTapVelocity) {
                        boolean c4;
                        boolean c3;
                        boolean c2;
                        boolean c1;
                        if (this.mInvert) {
                            c1 = this.mExpanded && this.getBottom() - handleBottom < this.mTapThreshold + this.mBottomOffset;
                            c2 = !this.mExpanded && handleTop < this.mTopMargin + this.mTopOffset + this.mHandleHeight - this.mTapThreshold;
                            c3 = this.mExpanded && this.getRight() - handleRight < this.mTapThreshold + this.mBottomOffset;
                            c4 = !this.mExpanded && handleLeft > this.mTopMargin + this.mTopOffset + this.mHandleWidth + this.mTapThreshold;
                        } else {
                            c1 = this.mExpanded && handleTop < this.mTapThreshold + this.mTopMargin + this.mTopOffset;
                            c2 = !this.mExpanded && handleTop > this.mBottomOffset + this.getBottom() - this.getTop() - this.mHandleHeight - this.mTapThreshold;
                            c3 = this.mExpanded && handleLeft < this.mTapThreshold + this.mTopMargin + this.mTopOffset;
                            c4 = !this.mExpanded && handleLeft > this.mBottomOffset + this.getRight() - this.getLeft() - this.mHandleWidth - this.mTapThreshold;
                        }
                        Log.d((String)LOG_TAG, (String)("ACTION_UP: c1: " + c1 + ", c2: " + c2 + ", c3: " + c3 + ", c4: " + c4));
                        if (vertical ? c1 || c2 : c3 || c4) {
                            if (this.mAllowSingleTap) {
                                this.playSoundEffect(0);
                                if (this.mExpanded) {
                                    this.animateClose(vertical ? handleTop : handleLeft);
                                    break;
                                }
                                this.animateOpen(vertical ? handleTop : handleLeft);
                                break;
                            }
                            this.performFling(vertical ? handleTop : handleLeft, velocity, false);
                            break;
                        }
                        this.performFling(vertical ? handleTop : handleLeft, velocity, false);
                        break;
                    }
                    this.performFling(vertical ? handleTop : handleLeft, velocity, false);
                }
            }
        }
        return this.mTracking || this.mAnimating || super.onTouchEvent(event);
    }

    private void animateClose(int position) {
        this.prepareTracking(position);
        this.performFling(position, this.mMaximumAcceleration, true);
    }

    private void animateOpen(int position) {
        this.prepareTracking(position);
        this.performFling(position, -this.mMaximumAcceleration, true);
    }

    private void performFling(int position, float velocity, boolean always) {
        long now;
        this.mAnimationPosition = position;
        this.mAnimatedVelocity = velocity;
        if (this.mExpanded) {
            boolean c2;
            boolean c1;
            int bottom = this.mVertical ? this.getBottom() : this.getRight();
            int handleHeight = this.mVertical ? this.mHandleHeight : this.mHandleWidth;
            Log.d((String)LOG_TAG, (String)("position: " + position + ", velocity: " + velocity + ", mMaximumMajorVelocity: " + this.mMaximumMajorVelocity));
            boolean bl = this.mInvert ? velocity < (float)this.mMaximumMajorVelocity : (c1 = velocity > (float)this.mMaximumMajorVelocity);
            boolean bl2 = this.mInvert ? bottom - (position + handleHeight) + this.mBottomOffset > handleHeight : (c2 = position > this.mTopOffset + this.mTopMargin + (this.mVertical ? this.mHandleHeight : this.mHandleWidth));
            boolean c3 = this.mInvert ? velocity < (float)(-this.mMaximumMajorVelocity) : velocity > (float)(-this.mMaximumMajorVelocity);
            Log.d((String)LOG_TAG, (String)("EXPANDED. c1: " + c1 + ", c2: " + c2 + ", c3: " + c3));
            if (velocity == 225.0f || velocity == 300.0f) {
                this.mAnimatedAcceleration = this.mMaximumAcceleration;
                if (this.mInvert) {
                    if (velocity > 0.0f) {
                        this.mAnimatedVelocity = 0.0f;
                    }
                } else if (velocity < 0.0f) {
                    this.mAnimatedVelocity = 0.0f;
                }
            } else if (always || c1 || c2 && c3) {
                this.mAnimatedAcceleration = this.mMaximumAcceleration;
                if (this.mInvert) {
                    if (velocity > 0.0f) {
                        this.mAnimatedVelocity = 0.0f;
                    }
                } else if (velocity < 0.0f) {
                    this.mAnimatedVelocity = 0.0f;
                }
            } else {
                this.mAnimatedAcceleration = -this.mMaximumAcceleration;
                if (this.mInvert) {
                    if (velocity < 0.0f) {
                        this.mAnimatedVelocity = 0.0f;
                    }
                } else if (velocity > 0.0f) {
                    this.mAnimatedVelocity = 0.0f;
                }
            }
        } else {
            boolean c2;
            boolean c1;
            boolean bl = this.mInvert ? velocity < (float)this.mMaximumMajorVelocity : (c1 = velocity > (float)this.mMaximumMajorVelocity);
            boolean bl3 = this.mInvert ? position < (this.mVertical ? this.getHeight() : this.getWidth()) / 2 : (c2 = position > (this.mVertical ? this.getHeight() : this.getWidth()) / 2);
            boolean c3 = this.mInvert ? velocity < (float)(-this.mMaximumMajorVelocity) : velocity > (float)(-this.mMaximumMajorVelocity);
            Log.d((String)LOG_TAG, (String)("COLLAPSED. position: " + position + ", velocity: " + velocity + ", mMaximumMajorVelocity: " + this.mMaximumMajorVelocity));
            Log.d((String)LOG_TAG, (String)("COLLAPSED. always: " + always + ", c1: " + c1 + ", c2: " + c2 + ", c3: " + c3));
            if (velocity == 225.0f || velocity == 300.0f) {
                this.mAnimatedAcceleration = -this.mMaximumAcceleration;
                if (this.mInvert) {
                    if (velocity < 0.0f) {
                        this.mAnimatedVelocity = 0.0f;
                    }
                } else if (velocity > 0.0f) {
                    this.mAnimatedVelocity = 0.0f;
                }
            } else if (!always && (c1 || c2 && c3)) {
                this.mAnimatedAcceleration = this.mMaximumAcceleration;
                if (this.mInvert) {
                    if (velocity > 0.0f) {
                        this.mAnimatedVelocity = 0.0f;
                    }
                } else if (velocity < 0.0f) {
                    this.mAnimatedVelocity = 0.0f;
                }
            } else {
                this.mAnimatedAcceleration = -this.mMaximumAcceleration;
                if (this.mInvert) {
                    if (velocity < 0.0f) {
                        this.mAnimatedVelocity = 0.0f;
                    }
                } else if (velocity > 0.0f) {
                    this.mAnimatedVelocity = 0.0f;
                }
            }
        }
        this.mAnimationLastTime = now = SystemClock.uptimeMillis();
        this.mCurrentAnimationTime = now + 16L;
        this.mAnimating = true;
        this.mHandler.removeMessages(1000);
        this.mHandler.sendMessageAtTime(this.mHandler.obtainMessage(1000), this.mCurrentAnimationTime);
        this.stopTracking();
    }

    private void prepareTracking(int position) {
        boolean opening;
        this.mTracking = true;
        this.mVelocityTracker = VelocityTracker.obtain();
        boolean bl = opening = !this.mExpanded;
        if (opening) {
            long now;
            this.mAnimatedAcceleration = this.mMaximumAcceleration;
            this.mAnimatedVelocity = this.mMaximumMajorVelocity;
            this.mAnimationPosition = this.mInvert ? (float)this.mTopMargin : (float)(this.mBottomOffset + (this.mVertical ? this.getHeight() - this.mHandleHeight : this.getWidth() - this.mHandleWidth));
            this.moveHandle((int)this.mAnimationPosition);
            this.mAnimating = true;
            this.mHandler.removeMessages(1000);
            this.mAnimationLastTime = now = SystemClock.uptimeMillis();
            this.mCurrentAnimationTime = now + 16L;
            this.mAnimating = true;
        } else {
            if (this.mAnimating) {
                this.mAnimating = false;
                this.mHandler.removeMessages(1000);
            }
            this.moveHandle(position);
        }
    }

    private void moveHandle(int position) {
        View handle = this.mHandle;
        Log.d((String)LOG_TAG, (String)("moveHandle() position: " + position));
        if (this.mVertical) {
            if (position == -10001) {
                if (this.mInvert) {
                    handle.offsetTopAndBottom(this.mBottomOffset + this.getBottom() - this.getTop() - this.mHandleHeight);
                } else {
                    handle.offsetTopAndBottom(this.mTopMargin + this.mTopOffset - handle.getTop());
                }
                this.invalidate();
            } else if (position == -10002) {
                if (this.mInvert) {
                    handle.offsetTopAndBottom(this.mTopMargin + this.mTopOffset - handle.getTop());
                } else {
                    handle.offsetTopAndBottom(this.mBottomOffset + this.getBottom() - this.getTop() - this.mHandleHeight - handle.getTop());
                }
                this.invalidate();
            } else {
                if (position >= this.mHandleHeight * 2) {
                    if (!this.hasTrackedAboveThreshold) {
                        this.hasTrackedAboveThreshold = true;
                        this.hasTrackedBelowThreshold = false;
                        if (this.mOnThresholdHitListener != null) {
                            this.mOnThresholdHitListener.onThresholdHit(false);
                        }
                    }
                } else if (!this.hasTrackedBelowThreshold) {
                    this.hasTrackedAboveThreshold = false;
                    this.hasTrackedBelowThreshold = true;
                    if (this.mOnThresholdHitListener != null) {
                        this.mOnThresholdHitListener.onThresholdHit(true);
                    }
                }
                int top = handle.getTop();
                int deltaY = position - top;
                if (position < this.mTopMargin + this.mTopOffset) {
                    deltaY = this.mTopMargin + this.mTopOffset - top;
                } else if (deltaY > this.mBottomOffset + this.getBottom() - this.getTop() - this.mHandleHeight - top) {
                    deltaY = this.mBottomOffset + this.getBottom() - this.getTop() - this.mHandleHeight - top;
                }
                handle.offsetTopAndBottom(deltaY);
                Rect frame = this.mFrame;
                Rect region = this.mInvalidate;
                handle.getHitRect(frame);
                region.set(frame);
                region.union(frame.left, frame.top - deltaY, frame.right, frame.bottom - deltaY);
                region.union(0, frame.bottom - deltaY, this.getWidth(), frame.bottom - deltaY + this.mContent.getHeight());
                this.invalidate(region);
            }
        } else if (position == -10001) {
            if (this.mInvert) {
                handle.offsetLeftAndRight(this.mBottomOffset + this.getRight() - this.getLeft() - this.mHandleWidth);
            } else {
                handle.offsetLeftAndRight(this.mTopMargin + this.mTopOffset - handle.getLeft());
            }
            this.invalidate();
        } else if (position == -10002) {
            if (this.mInvert) {
                handle.offsetLeftAndRight(this.mTopMargin + this.mTopOffset - handle.getLeft());
            } else {
                handle.offsetLeftAndRight(this.mBottomOffset + this.getRight() - this.getLeft() - this.mHandleWidth - handle.getLeft());
            }
            this.invalidate();
        } else {
            int left = handle.getLeft();
            int deltaX = position - left;
            if (position < this.mTopMargin + this.mTopOffset) {
                deltaX = this.mTopMargin + this.mTopOffset - left;
            } else if (deltaX > this.mBottomOffset + this.getRight() - this.getLeft() - this.mHandleWidth - left) {
                deltaX = this.mBottomOffset + this.getRight() - this.getLeft() - this.mHandleWidth - left;
            }
            handle.offsetLeftAndRight(deltaX);
            Rect frame = this.mFrame;
            Rect region = this.mInvalidate;
            handle.getHitRect(frame);
            region.set(frame);
            region.union(frame.left - deltaX, frame.top, frame.right - deltaX, frame.bottom);
            region.union(frame.right - deltaX, 0, frame.right - deltaX + this.mContent.getWidth(), this.getHeight());
            this.invalidate(region);
        }
    }

    private void prepareContent() {
        if (this.mAnimating) {
            return;
        }
        View content = this.mContent;
        if (content.isLayoutRequested()) {
            if (this.mVertical) {
                int handleHeight = this.mHandleHeight;
                int height = this.getBottom() - this.getTop() - handleHeight - this.mTopOffset;
                content.measure(View.MeasureSpec.makeMeasureSpec((int)(this.getRight() - this.getLeft()), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
                Log.d((String)LOG_TAG, (String)"content.layout(2)");
                if (this.mInvert) {
                    content.layout(0, this.mTopOffset, content.getMeasuredWidth(), this.mTopOffset + content.getMeasuredHeight());
                } else {
                    content.layout(0, this.mTopOffset + handleHeight, content.getMeasuredWidth(), this.mTopOffset + handleHeight + content.getMeasuredHeight());
                }
            } else {
                int handleWidth = this.mHandle.getWidth();
                int width = this.getRight() - this.getLeft() - handleWidth - this.mTopOffset;
                content.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(this.getBottom() - this.getTop()), (int)0x40000000));
                if (this.mInvert) {
                    content.layout(this.mTopOffset, 0, this.mTopOffset + content.getMeasuredWidth(), content.getMeasuredHeight());
                } else {
                    content.layout(handleWidth + this.mTopOffset, 0, this.mTopOffset + handleWidth + content.getMeasuredWidth(), content.getMeasuredHeight());
                }
            }
        }
        content.getViewTreeObserver().dispatchOnPreDraw();
        content.buildDrawingCache();
        content.setVisibility(8);
    }

    private void stopTracking() {
        this.mHandle.setPressed(false);
        this.mTracking = false;
        if (this.mOnDrawerScrollListener != null) {
            this.mOnDrawerScrollListener.onScrollEnded();
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void doAnimation() {
        if (this.mAnimating) {
            this.incrementAnimation();
            if (this.mInvert) {
                if (this.mAnimationPosition < (float)this.mTopOffset) {
                    this.mAnimating = false;
                    this.closeDrawer();
                } else {
                    int n = this.mVertical ? this.getHeight() : this.getWidth();
                    if (this.mAnimationPosition >= (float)(this.mTopOffset + n - 1)) {
                        this.mAnimating = false;
                        this.openDrawer();
                    } else {
                        this.moveHandle((int)this.mAnimationPosition);
                        this.mCurrentAnimationTime += 16L;
                        this.mHandler.sendMessageAtTime(this.mHandler.obtainMessage(1000), this.mCurrentAnimationTime);
                    }
                }
            } else {
                int n = this.mVertical ? this.getHeight() : this.getWidth();
                if (this.mAnimationPosition >= (float)(this.mBottomOffset + n - 1)) {
                    this.mAnimating = false;
                    this.closeDrawer();
                } else if (this.mAnimationPosition < (float)this.mTopOffset) {
                    this.mAnimating = false;
                    this.openDrawer();
                } else {
                    this.moveHandle((int)this.mAnimationPosition);
                    this.mCurrentAnimationTime += 16L;
                    this.mHandler.sendMessageAtTime(this.mHandler.obtainMessage(1000), this.mCurrentAnimationTime);
                }
            }
        }
    }

    private void incrementAnimation() {
        long now = SystemClock.uptimeMillis();
        float t = (float)(now - this.mAnimationLastTime) / 1000.0f;
        float position = this.mAnimationPosition;
        float v = this.mAnimatedVelocity;
        float a = this.mInvert ? this.mAnimatedAcceleration : this.mAnimatedAcceleration;
        this.mAnimationPosition = position + v * t + 0.5f * a * t * t;
        this.mAnimatedVelocity = v + a * t;
        this.mAnimationLastTime = now;
    }

    public void toggle() {
        if (!this.mExpanded) {
            this.openDrawer();
        } else {
            this.closeDrawer();
        }
        this.invalidate();
        this.requestLayout();
    }

    public void animateToggle() {
        if (!this.mExpanded) {
            this.animateOpen();
        } else {
            this.animateClose();
        }
    }

    public void open() {
        this.openDrawer();
        this.invalidate();
        this.requestLayout();
        this.sendAccessibilityEvent(32);
    }

    public void close() {
        this.closeDrawer();
        this.invalidate();
        this.requestLayout();
    }

    public void animateClose() {
        this.prepareContent();
        OnDrawerScrollListener scrollListener = this.mOnDrawerScrollListener;
        if (scrollListener != null) {
            scrollListener.onScrollStarted();
        }
        this.animateClose(this.mVertical ? this.mHandle.getTop() : this.mHandle.getLeft());
        if (scrollListener != null) {
            scrollListener.onScrollEnded();
        }
    }

    public void animateOpen() {
        this.prepareContent();
        OnDrawerScrollListener scrollListener = this.mOnDrawerScrollListener;
        if (scrollListener != null) {
            scrollListener.onScrollStarted();
        }
        this.animateOpen(this.mVertical ? this.mHandle.getTop() : this.mHandle.getLeft());
        this.sendAccessibilityEvent(32);
        if (scrollListener != null) {
            scrollListener.onScrollEnded();
        }
    }

    private void closeDrawer() {
        this.moveHandle(-10002);
        this.mContent.setVisibility(8);
        this.mContent.destroyDrawingCache();
        if (!this.mExpanded) {
            return;
        }
        this.mExpanded = false;
        if (this.mOnDrawerCloseListener != null) {
            this.mOnDrawerCloseListener.onDrawerClosed();
        }
        if (!this.hasTrackedBelowThreshold && this.mOnThresholdHitListener != null) {
            this.mOnThresholdHitListener.onThresholdHit(true);
        }
    }

    private void openDrawer() {
        this.moveHandle(-10001);
        this.mContent.setVisibility(0);
        if (this.mExpanded) {
            return;
        }
        this.mExpanded = true;
        if (this.mOnDrawerOpenListener != null) {
            this.mOnDrawerOpenListener.onDrawerOpened();
        }
        if (!this.hasTrackedAboveThreshold && this.mOnThresholdHitListener != null) {
            this.mOnThresholdHitListener.onThresholdHit(false);
        }
    }

    public void setOnThresholdHitListener(OnThresholdHitListener onThresholdHitListener) {
        this.mOnThresholdHitListener = onThresholdHitListener;
    }

    public void setOnDrawerOpenListener(OnDrawerOpenListener onDrawerOpenListener) {
        this.mOnDrawerOpenListener = onDrawerOpenListener;
    }

    public void setOnDrawerCloseListener(OnDrawerCloseListener onDrawerCloseListener) {
        this.mOnDrawerCloseListener = onDrawerCloseListener;
    }

    public void setOnDrawerScrollListener(OnDrawerScrollListener onDrawerScrollListener) {
        this.mOnDrawerScrollListener = onDrawerScrollListener;
    }

    public View getHandle() {
        return this.mHandle;
    }

    public View getContent() {
        return this.mContent;
    }

    public void unlock() {
        this.mLocked = false;
    }

    public void lock() {
        this.mLocked = true;
    }

    public boolean isOpened() {
        return this.mExpanded;
    }

    public boolean isMoving() {
        return this.mTracking || this.mAnimating;
    }

    private class SlidingHandler
    extends Handler {
        private SlidingHandler() {
        }

        public void handleMessage(Message m) {
            switch (m.what) {
                case 1000: {
                    MultiDirectionSlidingDrawer.this.doAnimation();
                }
            }
        }
    }

    private class DrawerToggler
    implements View.OnClickListener {
        private DrawerToggler() {
        }

        public void onClick(View v) {
            if (MultiDirectionSlidingDrawer.this.mLocked) {
                return;
            }
            if (MultiDirectionSlidingDrawer.this.mAnimateOnClick) {
                MultiDirectionSlidingDrawer.this.animateToggle();
            } else {
                MultiDirectionSlidingDrawer.this.toggle();
            }
        }
    }

    public static interface OnThresholdHitListener {
        public void onThresholdHit(boolean var1);
    }

    public static interface OnDrawerScrollListener {
        public void onScrollStarted();

        public void onScrollEnded();
    }

    public static interface OnDrawerCloseListener {
        public void onDrawerClosed();
    }

    public static interface OnDrawerOpenListener {
        public void onDrawerOpened();
    }
}

