/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.imageloader;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.widget.ImageView;

public class ImageLoaderHandler
extends Handler {
    private ImageView imageView;
    private String imageUrl;
    private Drawable errorDrawable;

    public ImageLoaderHandler(ImageView imageView, String imageUrl) {
        this.imageView = imageView;
        this.imageUrl = imageUrl;
    }

    public ImageLoaderHandler(ImageView imageView, String imageUrl, Drawable errorDrawable) {
        this(imageView, imageUrl);
        this.errorDrawable = errorDrawable;
    }

    public final void handleMessage(Message msg) {
        if (msg.what == 0) {
            this.handleImageLoadedMessage(msg);
        }
    }

    protected final void handleImageLoadedMessage(Message msg) {
        Bundle data = msg.getData();
        Bitmap bitmap = (Bitmap)data.getParcelable("droidfu:extra_bitmap");
        this.handleImageLoaded(bitmap, msg);
    }

    public boolean handleImageLoaded(Bitmap bitmap, Message msg) {
        String forUrl = (String)this.imageView.getTag();
        if (this.imageUrl.equals(forUrl)) {
            Bitmap image;
            Bitmap bitmap2 = image = bitmap != null || this.errorDrawable == null ? bitmap : ((BitmapDrawable)this.errorDrawable).getBitmap();
            if (image != null) {
                this.imageView.setImageBitmap(image);
            }
            return true;
        }
        return false;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public ImageView getImageView() {
        return this.imageView;
    }

    public void setImageView(ImageView imageView) {
        this.imageView = imageView;
    }

    public Drawable getErrorDrawable() {
        return this.errorDrawable;
    }

    public void setErrorDrawable(Drawable errorDrawable) {
        this.errorDrawable = errorDrawable;
    }
}

