/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.http;

import android.os.SystemClock;
import android.util.Log;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashSet;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;

public class BetterHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    private static final int RETRY_SLEEP_TIME_MILLIS = 1500;
    private static HashSet<Class<?>> exceptionWhitelist = new HashSet();
    private static HashSet<Class<?>> exceptionBlacklist = new HashSet();
    private int maxRetries;
    private int timesRetried;

    public BetterHttpRequestRetryHandler(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        boolean sent;
        this.timesRetried = executionCount;
        Boolean b = (Boolean)context.getAttribute("http.request_sent");
        boolean bl = sent = b != null && b != false;
        boolean retry = executionCount > this.maxRetries ? false : (exceptionBlacklist.contains(exception.getClass()) ? false : (exceptionWhitelist.contains(exception.getClass()) ? true : !sent));
        if (retry) {
            Log.e((String)"BetterHttp", (String)("request failed (" + exception.getClass().getCanonicalName() + ": " + exception.getMessage() + " / attempt " + executionCount + "), will retry in " + 1.5 + " seconds"));
            SystemClock.sleep((long)1500L);
        } else {
            Log.e((String)"BetterHttp", (String)("request failed after " + executionCount + " attempts"));
            exception.printStackTrace();
        }
        return retry;
    }

    public int getTimesRetried() {
        return this.timesRetried;
    }

    static {
        exceptionWhitelist.add(NoHttpResponseException.class);
        exceptionWhitelist.add(UnknownHostException.class);
        exceptionWhitelist.add(SocketException.class);
        exceptionBlacklist.add(InterruptedIOException.class);
        exceptionBlacklist.add(SSLHandshakeException.class);
    }
}

