/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.http;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import oak.external.com.github.droidfu.cachefu.HttpResponseCache;
import oak.external.com.github.droidfu.http.BetterHttpRequest;
import oak.external.com.github.droidfu.http.CachedHttpRequest;
import oak.external.com.github.droidfu.http.ConnectionChangedBroadcastReceiver;
import oak.external.com.github.droidfu.http.HttpDelete;
import oak.external.com.github.droidfu.http.HttpGet;
import oak.external.com.github.droidfu.http.HttpPost;
import oak.external.com.github.droidfu.http.HttpPut;
import oak.external.com.github.droidfu.http.ssl.EasySSLSocketFactory;
import oak.external.com.github.droidfu.support.DiagnosticSupport;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;

public class BetterHttp {
    static final String LOG_TAG = "BetterHttp";
    public static final int DEFAULT_MAX_CONNECTIONS = 4;
    public static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    public static final String DEFAULT_HTTP_USER_AGENT = "Android/DroidFu";
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ENCODING_GZIP = "gzip";
    private static int maxConnections = 4;
    private static int socketTimeout = 30000;
    private static String httpUserAgent = "Android/DroidFu";
    private static HashMap<String, String> defaultHeaders = new HashMap();
    private static AbstractHttpClient httpClient;
    private static Context appContext;
    private static HttpResponseCache responseCache;

    public static void setupHttpClient() {
        BasicHttpParams httpParams = new BasicHttpParams();
        ConnManagerParams.setTimeout((HttpParams)httpParams, (long)socketTimeout);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)httpParams, (ConnPerRoute)new ConnPerRouteBean(maxConnections));
        ConnManagerParams.setMaxTotalConnections((HttpParams)httpParams, (int)4);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)socketTimeout);
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpParams, (boolean)true);
        HttpProtocolParams.setVersion((HttpParams)httpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUserAgent((HttpParams)httpParams, (String)httpUserAgent);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        if (DiagnosticSupport.ANDROID_API_LEVEL >= 7) {
            schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        } else {
            schemeRegistry.register(new Scheme("https", (SocketFactory)new EasySSLSocketFactory(), 443));
        }
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)httpParams, schemeRegistry);
        httpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)httpParams);
    }

    public static void enableResponseCache(int initialCapacity, long expirationInMinutes, int maxConcurrentThreads) {
        responseCache = new HttpResponseCache(initialCapacity, expirationInMinutes, maxConcurrentThreads);
    }

    public static void enableGZIPEncoding() {
        httpClient.addRequestInterceptor((HttpRequestInterceptor)new GZIPHttpRequestInterceptor());
        httpClient.addResponseInterceptor((HttpResponseInterceptor)new GZIPHttpResponseInterceptor());
    }

    public static void enableResponseCache(Context context, int initialCapacity, long expirationInMinutes, int maxConcurrentThreads, int diskCacheStorageDevice) {
        BetterHttp.enableResponseCache(initialCapacity, expirationInMinutes, maxConcurrentThreads);
        responseCache.enableDiskCache(context, diskCacheStorageDevice);
    }

    public static HttpResponseCache getResponseCache() {
        return responseCache;
    }

    public static void setHttpClient(AbstractHttpClient httpClient) {
        BetterHttp.httpClient = httpClient;
    }

    public static AbstractHttpClient getHttpClient() {
        return httpClient;
    }

    public static void updateProxySettings() {
        if (appContext == null) {
            return;
        }
        HttpParams httpParams = httpClient.getParams();
        ConnectivityManager connectivity = (ConnectivityManager)appContext.getSystemService("connectivity");
        NetworkInfo nwInfo = connectivity.getActiveNetworkInfo();
        if (nwInfo == null) {
            return;
        }
        Log.i((String)LOG_TAG, (String)nwInfo.toString());
        if (nwInfo.getType() == 0) {
            int proxyPort;
            String proxyHost = Proxy.getHost((Context)appContext);
            if (proxyHost == null) {
                proxyHost = Proxy.getDefaultHost();
            }
            if ((proxyPort = Proxy.getPort((Context)appContext)) == -1) {
                proxyPort = Proxy.getDefaultPort();
            }
            if (proxyHost != null && proxyPort > -1) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                httpParams.setParameter("http.route.default-proxy", (Object)proxy);
            } else {
                httpParams.setParameter("http.route.default-proxy", null);
            }
        } else {
            httpParams.setParameter("http.route.default-proxy", null);
        }
    }

    public static BetterHttpRequest get(String url) {
        return BetterHttp.get(url, false);
    }

    public static BetterHttpRequest get(String url, boolean cached) {
        if (cached && responseCache != null && responseCache.containsKey(url)) {
            return new CachedHttpRequest(url);
        }
        return new HttpGet(httpClient, url, defaultHeaders);
    }

    public static BetterHttpRequest post(String url) {
        return new HttpPost(httpClient, url, defaultHeaders);
    }

    public static BetterHttpRequest post(String url, HttpEntity payload) {
        return new HttpPost(httpClient, url, payload, defaultHeaders);
    }

    public static BetterHttpRequest put(String url) {
        return new HttpPut(httpClient, url, defaultHeaders);
    }

    public static BetterHttpRequest put(String url, HttpEntity payload) {
        return new HttpPut(httpClient, url, payload, defaultHeaders);
    }

    public static BetterHttpRequest delete(String url) {
        return new HttpDelete(httpClient, url, defaultHeaders);
    }

    public static void setMaximumConnections(int maxConnections) {
        BetterHttp.maxConnections = maxConnections;
    }

    public static void setSocketTimeout(int socketTimeout) {
        BetterHttp.socketTimeout = socketTimeout;
        HttpConnectionParams.setSoTimeout((HttpParams)httpClient.getParams(), (int)socketTimeout);
    }

    public static int getSocketTimeout() {
        return socketTimeout;
    }

    public static void setDefaultHeader(String header, String value) {
        defaultHeaders.put(header, value);
    }

    public static HashMap<String, String> getDefaultHeaders() {
        return defaultHeaders;
    }

    public static void setContext(Context context) {
        if (appContext != null) {
            return;
        }
        appContext = context.getApplicationContext();
        appContext.registerReceiver((BroadcastReceiver)new ConnectionChangedBroadcastReceiver(), new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    public static void setPortForScheme(String scheme, int port) {
        Scheme _scheme = new Scheme(scheme, (SocketFactory)PlainSocketFactory.getSocketFactory(), port);
        httpClient.getConnectionManager().getSchemeRegistry().register(_scheme);
    }

    public static void setUserAgent(String userAgent) {
        httpUserAgent = userAgent;
        HttpProtocolParams.setUserAgent((HttpParams)httpClient.getParams(), (String)userAgent);
    }

    static class GZIPInflatingEntity
    extends HttpEntityWrapper {
        public GZIPInflatingEntity(HttpEntity wrapped) {
            super(wrapped);
        }

        public InputStream getContent() throws IOException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        public long getContentLength() {
            return -1L;
        }
    }

    static class GZIPHttpResponseInterceptor
    implements HttpResponseInterceptor {
        GZIPHttpResponseInterceptor() {
        }

        public void process(HttpResponse response, HttpContext context) {
            HttpEntity entity = response.getEntity();
            Header encoding = entity.getContentEncoding();
            if (encoding != null) {
                for (HeaderElement element : encoding.getElements()) {
                    if (!element.getName().equalsIgnoreCase(BetterHttp.ENCODING_GZIP)) continue;
                    response.setEntity((HttpEntity)new GZIPInflatingEntity(response.getEntity()));
                    break;
                }
            }
        }
    }

    static class GZIPHttpRequestInterceptor
    implements HttpRequestInterceptor {
        GZIPHttpRequestInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) {
            if (!request.containsHeader(BetterHttp.HEADER_ACCEPT_ENCODING)) {
                request.addHeader(BetterHttp.HEADER_ACCEPT_ENCODING, BetterHttp.ENCODING_GZIP);
            }
        }
    }
}

