/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.cachefu;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import oak.external.com.github.droidfu.cachefu.AbstractCache;
import oak.external.com.github.droidfu.cachefu.CacheHelper;
import oak.external.com.github.droidfu.cachefu.CachedModel;

public class ModelCache
extends AbstractCache<String, CachedModel> {
    private long transactionCount = -9223372036854775807L;

    public ModelCache(int initialCapacity, long expirationInMinutes, int maxConcurrentThreads) {
        super("ModelCache", initialCapacity, expirationInMinutes, maxConcurrentThreads);
    }

    @Override
    public synchronized CachedModel put(String key, CachedModel value) {
        value.setTransactionId(this.transactionCount++);
        return super.put(key, value);
    }

    public synchronized void removeAllWithPrefix(String prefix) {
        CacheHelper.removeAllWithStringPrefix(this, prefix);
    }

    @Override
    public String getFileNameForKey(String url) {
        return CacheHelper.getFileNameFromUrl(url);
    }

    @Override
    protected CachedModel readValueFromDisk(File file) throws IOException {
        FileInputStream istream = new FileInputStream(file);
        byte[] dataWritten = new byte[(int)file.length()];
        BufferedInputStream bistream = new BufferedInputStream(istream);
        bistream.read(dataWritten);
        bistream.close();
        Parcel parcelIn = Parcel.obtain();
        parcelIn.unmarshall(dataWritten, 0, dataWritten.length);
        parcelIn.setDataPosition(0);
        String className = parcelIn.readString();
        if (className == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (CachedModel)parcelIn.readParcelable(clazz.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected void writeValueToDisk(File file, CachedModel data) throws IOException {
        Parcel parcelOut = Parcel.obtain();
        parcelOut.writeString(data.getClass().getCanonicalName());
        parcelOut.writeParcelable((Parcelable)data, 0);
        FileOutputStream ostream = new FileOutputStream(file);
        BufferedOutputStream bistream = new BufferedOutputStream(ostream);
        bistream.write(parcelOut.marshall());
        bistream.close();
    }
}

