/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.cachefu;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import oak.external.com.github.droidfu.cachefu.AbstractCache;
import oak.external.com.github.droidfu.cachefu.CacheHelper;

public class ImageCache
extends AbstractCache<String, byte[]> {
    public ImageCache(int initialCapacity, long expirationInMinutes, int maxConcurrentThreads) {
        super("ImageCache", initialCapacity, expirationInMinutes, maxConcurrentThreads);
    }

    public synchronized void removeAllWithPrefix(String urlPrefix) {
        CacheHelper.removeAllWithStringPrefix(this, urlPrefix);
    }

    @Override
    public String getFileNameForKey(String imageUrl) {
        return CacheHelper.getFileNameFromUrl(imageUrl);
    }

    @Override
    protected byte[] readValueFromDisk(File file) throws IOException {
        BufferedInputStream istream = new BufferedInputStream(new FileInputStream(file), 8192);
        long fileSize = file.length();
        if (fileSize > Integer.MAX_VALUE) {
            throw new IOException("Cannot read files larger than 2147483647 bytes");
        }
        int imageDataLength = (int)fileSize;
        byte[] imageData = new byte[imageDataLength];
        istream.read(imageData, 0, imageDataLength);
        istream.close();
        return imageData;
    }

    public synchronized Bitmap getBitmap(Object elementKey) {
        byte[] imageData = (byte[])super.get(elementKey);
        if (imageData == null) {
            return null;
        }
        return BitmapFactory.decodeByteArray((byte[])imageData, (int)0, (int)imageData.length);
    }

    @Override
    protected void writeValueToDisk(File file, byte[] imageData) throws IOException {
        BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(file));
        ostream.write(imageData);
        ostream.close();
    }
}

