/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.cachefu;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import oak.external.com.github.droidfu.cachefu.AbstractCache;
import oak.external.com.github.droidfu.cachefu.CacheHelper;
import oak.external.com.github.droidfu.http.CachedHttpResponse;

public class HttpResponseCache
extends AbstractCache<String, CachedHttpResponse.ResponseData> {
    public HttpResponseCache(int initialCapacity, long expirationInMinutes, int maxConcurrentThreads) {
        super("HttpCache", initialCapacity, expirationInMinutes, maxConcurrentThreads);
    }

    public synchronized void removeAllWithPrefix(String urlPrefix) {
        CacheHelper.removeAllWithStringPrefix(this, urlPrefix);
    }

    @Override
    public String getFileNameForKey(String url) {
        return CacheHelper.getFileNameFromUrl(url);
    }

    @Override
    protected CachedHttpResponse.ResponseData readValueFromDisk(File file) throws IOException {
        BufferedInputStream istream = new BufferedInputStream(new FileInputStream(file));
        long fileSize = file.length();
        if (fileSize > Integer.MAX_VALUE) {
            throw new IOException("Cannot read files larger than 2147483647 bytes");
        }
        int statusCode = istream.read();
        int responseDataLength = (int)fileSize - 1;
        byte[] responseBody = new byte[responseDataLength];
        istream.read(responseBody, 0, responseDataLength);
        istream.close();
        return new CachedHttpResponse.ResponseData(statusCode, responseBody);
    }

    @Override
    protected void writeValueToDisk(File file, CachedHttpResponse.ResponseData data) throws IOException {
        BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(file));
        ostream.write(data.getStatusCode());
        ostream.write(data.getResponseBody());
        ostream.close();
    }
}

