/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.cachefu;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import oak.external.com.github.droidfu.cachefu.ModelCache;

public abstract class CachedModel
implements Parcelable {
    private String id;
    private long transactionId = Long.MIN_VALUE;

    public CachedModel() {
    }

    public CachedModel(Parcel source) throws IOException {
        this.readFromParcel(source);
    }

    public CachedModel(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    void setTransactionId(long transactionId) {
        this.transactionId = transactionId;
    }

    public String getKey() {
        if (this.id == null) {
            return null;
        }
        return this.createKey(this.id);
    }

    public static CachedModel find(ModelCache modelCache, String id, Class<? extends CachedModel> clazz) {
        CachedModel testObject;
        try {
            testObject = clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
        testObject.setId(id);
        if (testObject.reload(modelCache)) {
            return testObject;
        }
        return null;
    }

    public boolean save(ModelCache modelCache) {
        return this.save(modelCache, this.getKey());
    }

    protected boolean save(ModelCache modelCache, String saveKey) {
        if (modelCache != null && saveKey != null) {
            modelCache.put(saveKey, this);
            return true;
        }
        return false;
    }

    public boolean reload(ModelCache modelCache) {
        String key = this.getKey();
        if (modelCache != null && key != null) {
            CachedModel cachedModel = (CachedModel)modelCache.get(key);
            if (cachedModel != null && cachedModel.transactionId > this.transactionId) {
                this.reloadFromCachedModel(modelCache, cachedModel);
                this.transactionId = cachedModel.transactionId;
                return true;
            }
            return false;
        }
        return false;
    }

    public abstract String createKey(String var1);

    public abstract boolean reloadFromCachedModel(ModelCache var1, CachedModel var2);

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeLong(this.transactionId);
    }

    public void readFromParcel(Parcel source) throws IOException {
        this.id = source.readString();
        this.transactionId = source.readLong();
    }
}

