/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.cachefu;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import com.google.common.collect.MapMaker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import oak.external.com.github.droidfu.support.StringSupport;

public abstract class AbstractCache<KeyT, ValT>
implements Map<KeyT, ValT> {
    public static final int DISK_CACHE_INTERNAL = 0;
    public static final int DISK_CACHE_SDCARD = 1;
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final String LOG_TAG = "Droid-Fu[CacheFu]";
    private boolean isDiskCacheEnabled;
    protected String diskCacheDirectory;
    private ConcurrentMap<KeyT, ValT> cache;
    private String name;
    private long expirationInMinutes;

    public AbstractCache(String name, int initialCapacity, long expirationInMinutes, int maxConcurrentThreads) {
        this.name = name;
        this.expirationInMinutes = expirationInMinutes;
        MapMaker mapMaker = new MapMaker();
        mapMaker.initialCapacity(initialCapacity);
        mapMaker.expiration(expirationInMinutes * 60L, TimeUnit.SECONDS);
        mapMaker.concurrencyLevel(maxConcurrentThreads);
        mapMaker.softValues();
        this.cache = mapMaker.makeMap();
    }

    private void sanitizeDiskCache() {
        File[] cachedFiles = new File(this.diskCacheDirectory).listFiles();
        if (cachedFiles == null) {
            return;
        }
        for (File f : cachedFiles) {
            long lastModified = f.lastModified();
            Date now = new Date();
            long ageInMinutes = (now.getTime() - lastModified) / 60000L;
            if (ageInMinutes < this.expirationInMinutes) continue;
            Log.d((String)this.name, (String)("DISK cache expiration for file " + f.toString()));
            f.delete();
        }
    }

    public boolean enableDiskCache(Context context, int storageDevice) {
        Context appContext = context.getApplicationContext();
        String rootDir = null;
        if (storageDevice == 1 && "mounted".equals(Environment.getExternalStorageState())) {
            rootDir = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/" + appContext.getPackageName() + "/cache";
        } else {
            File internalCacheDir = appContext.getCacheDir();
            if (internalCacheDir == null) {
                this.isDiskCacheEnabled = false;
                return false;
            }
            rootDir = internalCacheDir.getAbsolutePath();
        }
        this.setRootDir(rootDir);
        File outFile = new File(this.diskCacheDirectory);
        if (outFile.mkdirs()) {
            File nomedia = new File(this.diskCacheDirectory, ".nomedia");
            try {
                nomedia.createNewFile();
            }
            catch (IOException e) {
                Log.e((String)LOG_TAG, (String)"Failed creating .nomedia file");
            }
        }
        this.isDiskCacheEnabled = outFile.exists();
        if (!this.isDiskCacheEnabled) {
            Log.w((String)LOG_TAG, (String)("Failed creating disk cache directory " + this.diskCacheDirectory));
        } else {
            Log.d((String)this.name, (String)("enabled write through to " + this.diskCacheDirectory));
            Log.d((String)this.name, (String)"sanitize DISK cache");
            this.sanitizeDiskCache();
        }
        return this.isDiskCacheEnabled;
    }

    private void setRootDir(String rootDir) {
        this.diskCacheDirectory = rootDir + "/cachefu/" + StringSupport.underscore(this.name.replaceAll("\\s", ""));
    }

    public String getDiskCacheDirectory() {
        return this.diskCacheDirectory;
    }

    public abstract String getFileNameForKey(KeyT var1);

    protected abstract ValT readValueFromDisk(File var1) throws IOException;

    protected abstract void writeValueToDisk(File var1, ValT var2) throws IOException;

    protected void cacheToDisk(KeyT key, ValT value) {
        File file = new File(this.diskCacheDirectory + "/" + this.getFileNameForKey(key));
        try {
            file.createNewFile();
            file.deleteOnExit();
            this.writeValueToDisk(file, value);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected File getFileForKey(KeyT key) {
        return new File(this.diskCacheDirectory + "/" + this.getFileNameForKey(key));
    }

    @Override
    public synchronized ValT get(Object elementKey) {
        Object key = elementKey;
        Object value = this.cache.get(key);
        if (value != null) {
            Log.d((String)this.name, (String)("MEM cache hit for " + key.toString()));
            return (ValT)value;
        }
        File file = this.getFileForKey(key);
        if (file.exists()) {
            long lastModified = file.lastModified();
            Date now = new Date();
            long ageInMinutes = (now.getTime() - lastModified) / 60000L;
            if (ageInMinutes >= this.expirationInMinutes) {
                Log.d((String)this.name, (String)("DISK cache expiration for file " + file.toString()));
                file.delete();
                return null;
            }
            Log.d((String)this.name, (String)("DISK cache hit for " + key.toString()));
            try {
                value = this.readValueFromDisk(file);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            if (value == null) {
                return null;
            }
            this.cache.put(key, value);
            return (ValT)value;
        }
        return null;
    }

    @Override
    public synchronized ValT put(KeyT key, ValT value) {
        if (this.isDiskCacheEnabled) {
            this.cacheToDisk(key, value);
        }
        return this.cache.put(key, value);
    }

    @Override
    public synchronized void putAll(Map<? extends KeyT, ? extends ValT> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.cache.containsKey(key) || this.isDiskCacheEnabled && this.getFileForKey(key).exists();
    }

    public synchronized boolean containsKeyInMemory(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.cache.containsValue(value);
    }

    @Override
    public synchronized ValT remove(Object key) {
        File cachedValue;
        ValT value = this.removeKey(key);
        if (this.isDiskCacheEnabled && (cachedValue = this.getFileForKey(key)).exists()) {
            cachedValue.delete();
        }
        return value;
    }

    public ValT removeKey(Object key) {
        return (ValT)this.cache.remove(key);
    }

    @Override
    public Set<KeyT> keySet() {
        return this.cache.keySet();
    }

    @Override
    public Set<Map.Entry<KeyT, ValT>> entrySet() {
        return this.cache.entrySet();
    }

    @Override
    public synchronized int size() {
        return this.cache.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public boolean isDiskCacheEnabled() {
        return this.isDiskCacheEnabled;
    }

    public void setDiskCacheEnabled(String rootDir) {
        if (rootDir != null && rootDir.length() > 0) {
            this.setRootDir(rootDir);
            this.isDiskCacheEnabled = true;
        } else {
            this.isDiskCacheEnabled = false;
        }
    }

    @Override
    public synchronized void clear() {
        this.cache.clear();
        if (this.isDiskCacheEnabled) {
            File[] cachedFiles = new File(this.diskCacheDirectory).listFiles();
            if (cachedFiles == null) {
                return;
            }
            for (File f : cachedFiles) {
                f.delete();
            }
        }
        Log.d((String)LOG_TAG, (String)"Cache cleared");
    }

    @Override
    public Collection<ValT> values() {
        return this.cache.values();
    }
}

