/*
 * Decompiled with CFR 0.152.
 */
package oak;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.TextView;
import java.io.IOException;
import java.util.HashMap;

public class TextViewWithFont
extends TextView {
    private static final String TAG = TextViewWithFont.class.getSimpleName();
    private static HashMap<String, Typeface> mFontMap;

    public TextViewWithFont(Context context) {
        this(context, null);
    }

    public TextViewWithFont(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TextViewWithFont(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        String fontName = null;
        if (attrs != null) {
            fontName = attrs.getAttributeValue("http://oak/oak/schema", "font");
        }
        if (fontName != null) {
            this.setTypeface(TextViewWithFont.getStaticTypeFace(context, fontName));
        }
    }

    public static Typeface getStaticTypeFace(Context context, String fontFileName) {
        Typeface typeface;
        if (mFontMap == null) {
            TextViewWithFont.initializeFontMap(context);
        }
        if ((typeface = mFontMap.get(fontFileName)) == null) {
            throw new IllegalArgumentException("Font name must match file name in assets/fonts/ directory: " + fontFileName);
        }
        return typeface;
    }

    private static void initializeFontMap(Context context) {
        mFontMap = new HashMap();
        AssetManager assetManager = context.getAssets();
        try {
            String[] fontFileNames;
            for (String fontFileName : fontFileNames = assetManager.list("fonts")) {
                Log.d((String)TAG, (String)("Found font in assets: " + fontFileName));
                Typeface typeface = Typeface.createFromAsset((AssetManager)assetManager, (String)("fonts/" + fontFileName));
                mFontMap.put(fontFileName, typeface);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

