/*
 * Decompiled with CFR 0.152.
 */
package oak;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.ImageView;
import oak.util.ScaleGestureDetector;

public class SwankyImageView
extends ImageView {
    private Matrix matrix = new Matrix();
    private static final int NONE = 0;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    private static final float MIN_SCALE = 1.0f;
    private float maxScale = 2.5f;
    private static final float FRICTION_K = 0.01f;
    private static final float VEL_THRESHOLD = 0.05f;
    private static final String ANDROID_SCHEMA = "http://schemas.android.com/apk/res/android";
    private int mode = 0;
    private long timeOfLastMoveEvent;
    private PointF last = new PointF();
    private PointF start = new PointF();
    private float saveScale = 1.0f;
    private float[] m;
    private float redundantXSpace;
    private float redundantYSpace;
    private boolean isCenterInside;
    private float viewWidth;
    private float viewHeight;
    private float right;
    private float bottom;
    private float origWidth;
    private float origHeight;
    private float bitmapWidth;
    private float bitmapHeight;
    private ScaleGestureDetector mScaleDetector;
    private GestureDetector mTapSwipeDetector;
    private View.OnClickListener clickListener;
    private static final Interpolator ZOOM_INTERPOLATOR = new Interpolator(){

        public float getInterpolation(float input) {
            return input * 2.0f - input * input;
        }
    };
    private AsyncTask<Void, Void, Void> mFlingTask;
    private long lastFrameCompleted;
    private static final int MSG_REDRAW = 1;
    private static final int MSG_STOP_ANIM = 2;
    private final Handler FLING_ANIM_HANDLER = new Handler(){
        private long lastUpdated;
        private final int FRAME_RATE = 25;

        public void handleMessage(Message msg) {
            if (this.lastUpdated < SwankyImageView.this.lastFrameCompleted) {
                this.lastUpdated = SwankyImageView.this.lastFrameCompleted;
                SwankyImageView.this.setImageMatrix(SwankyImageView.this.matrix);
                SwankyImageView.this.invalidate();
            } else if (msg.what == 1) {
                this.sendEmptyMessage(1);
                return;
            }
            if (msg.what == 1) {
                this.sendEmptyMessageDelayed(1, 25L);
            } else if (msg.what == 2) {
                this.removeMessages(1);
                this.removeMessages(2);
            }
        }
    };

    public SwankyImageView(Context context) {
        super(context);
        this.initialize(null);
    }

    public SwankyImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(attrs);
    }

    public SwankyImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialize(attrs);
    }

    private void initialize(AttributeSet attrs) {
        int scaleType;
        this.mScaleDetector = new ScaleGestureDetector(this.getContext(), new ScaleListener());
        this.mTapSwipeDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new TapSwipeListener());
        if (attrs != null && (scaleType = attrs.getAttributeIntValue(ANDROID_SCHEMA, "scaleType", 6)) == 7) {
            this.isCenterInside = true;
        }
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.matrix.setTranslate(1.0f, 1.0f);
        this.m = new float[9];
        Drawable d = this.getDrawable();
        this.setImageMatrix(this.matrix);
        if (d != null) {
            this.setImageBitmap(((BitmapDrawable)d).getBitmap());
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mScaleDetector.onTouchEvent(event);
        this.mTapSwipeDetector.onTouchEvent(event);
        this.matrix.getValues(this.m);
        float x = this.m[2];
        float y = this.m[5];
        PointF curr = new PointF(event.getX(), event.getY());
        switch (event.getAction() & 0xFF) {
            case 0: {
                if (this.mFlingTask != null) {
                    this.mFlingTask.cancel(true);
                }
                this.last.set(event.getX(), event.getY());
                this.start.set(this.last);
                this.mode = 1;
                break;
            }
            case 2: {
                this.timeOfLastMoveEvent = System.currentTimeMillis();
                if (this.mode != 1) break;
                float deltaX = curr.x - this.last.x;
                float deltaY = curr.y - this.last.y;
                float scaleWidth = Math.round(this.origWidth * this.saveScale);
                float scaleHeight = Math.round(this.origHeight * this.saveScale);
                if (scaleWidth < this.viewWidth) {
                    deltaX = 0.0f;
                    if (y + deltaY > 0.0f) {
                        deltaY = -y;
                    } else if (y + deltaY < -this.bottom) {
                        deltaY = -(y + this.bottom);
                    }
                } else if (scaleHeight < this.viewHeight) {
                    deltaY = 0.0f;
                    if (x + deltaX > 0.0f) {
                        deltaX = -x;
                    } else if (x + deltaX < -this.right) {
                        deltaX = -(x + this.right);
                    }
                } else {
                    if (x + deltaX > 0.0f) {
                        deltaX = -x;
                    } else if (x + deltaX < -this.right) {
                        deltaX = -(x + this.right);
                    }
                    if (y + deltaY > 0.0f) {
                        deltaY = -y;
                    } else if (y + deltaY < -this.bottom) {
                        deltaY = -(y + this.bottom);
                    }
                }
                this.matrix.postTranslate(deltaX, deltaY);
                this.last.set(curr.x, curr.y);
                break;
            }
            case 6: {
                if (event.getPointerCount() != 2) break;
                int pointerRemaining = event.getAction() == 262 ? 0 : 1;
                this.last.set(event.getX(pointerRemaining), event.getY(pointerRemaining));
                this.mode = 1;
                break;
            }
            case 1: {
                this.mode = 0;
            }
        }
        this.setImageMatrix(this.matrix);
        this.invalidate();
        return true;
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.bitmapWidth = bm.getWidth();
        this.bitmapHeight = bm.getHeight();
    }

    public void setImageResource(int resId) {
        this.setImageBitmap(BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId));
    }

    public float getCurrentScale() {
        return this.saveScale;
    }

    public void setMaxScale(float scale) throws IllegalArgumentException {
        if (scale <= 1.0f) {
            throw new IllegalArgumentException("Max scale must be greater than 1.");
        }
        this.resetScale();
        this.maxScale = scale;
    }

    public void resetScale() {
        this.last = new PointF();
        this.start = new PointF();
        this.fitToScreen();
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.clickListener = l;
    }

    private void onClick() {
        if (this.clickListener != null) {
            this.clickListener.onClick((View)this);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.viewWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.viewHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.fitToScreen();
    }

    private void fitToScreen() {
        float scale = this.isCenterInside ? Math.min(this.viewWidth / this.bitmapWidth, this.viewHeight / this.bitmapHeight) : Math.max(this.viewWidth / this.bitmapWidth, this.viewHeight / this.bitmapHeight);
        this.matrix.setScale(scale, scale);
        this.saveScale = 1.0f;
        this.redundantYSpace = (this.viewHeight - scale * this.bitmapHeight) / 2.0f;
        this.redundantXSpace = (this.viewWidth - scale * this.bitmapWidth) / 2.0f;
        this.matrix.postTranslate(this.redundantXSpace, this.redundantYSpace);
        this.origWidth = this.viewWidth - 2.0f * this.redundantXSpace;
        this.origHeight = this.viewHeight - 2.0f * this.redundantYSpace;
        this.right = this.viewWidth * this.saveScale - this.viewWidth - 2.0f * this.redundantXSpace * this.saveScale;
        this.bottom = this.viewHeight * this.saveScale - this.viewHeight - 2.0f * this.redundantYSpace * this.saveScale;
        this.setImageMatrix(this.matrix);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 8 || visibility == 4) {
            if (this.mFlingTask != null) {
                this.mFlingTask.cancel(true);
                this.mFlingTask = null;
            }
            this.FLING_ANIM_HANDLER.sendEmptyMessage(2);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mFlingTask != null) {
            this.mFlingTask.cancel(true);
            this.mFlingTask = null;
        }
        this.FLING_ANIM_HANDLER.sendEmptyMessage(2);
    }

    private class ZoomAnimation
    extends Animation {
        private float startScale;
        private float endScale;
        private float centerX;
        private float centerY;

        public ZoomAnimation(float startScale, float endScale, float centerX, float centerY) {
            this.startScale = startScale;
            this.endScale = endScale;
            this.centerX = centerX;
            this.centerY = centerY;
            this.setDuration(250L);
            this.setInterpolator(ZOOM_INTERPOLATOR);
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            boolean viewTallerThanImg;
            float origScale = SwankyImageView.this.saveScale;
            SwankyImageView.this.saveScale = this.startScale + (this.endScale - this.startScale) * interpolatedTime;
            float scaleFactor = SwankyImageView.this.saveScale / origScale;
            SwankyImageView.this.right = SwankyImageView.this.viewWidth * SwankyImageView.this.saveScale - SwankyImageView.this.viewWidth - 2.0f * SwankyImageView.this.redundantXSpace * SwankyImageView.this.saveScale;
            SwankyImageView.this.bottom = SwankyImageView.this.viewHeight * SwankyImageView.this.saveScale - SwankyImageView.this.viewHeight - 2.0f * SwankyImageView.this.redundantYSpace * SwankyImageView.this.saveScale;
            boolean viewWiderThanImg = SwankyImageView.this.origWidth * SwankyImageView.this.saveScale <= SwankyImageView.this.viewWidth;
            boolean bl = viewTallerThanImg = SwankyImageView.this.origHeight * SwankyImageView.this.saveScale <= SwankyImageView.this.viewHeight;
            if (viewWiderThanImg || viewTallerThanImg) {
                if (viewWiderThanImg && !viewTallerThanImg) {
                    SwankyImageView.this.matrix.postScale(scaleFactor, scaleFactor, SwankyImageView.this.viewWidth / 2.0f, this.centerY);
                } else if (!viewWiderThanImg && viewTallerThanImg) {
                    SwankyImageView.this.matrix.postScale(scaleFactor, scaleFactor, this.centerX, SwankyImageView.this.viewHeight / 2.0f);
                } else {
                    SwankyImageView.this.matrix.postScale(scaleFactor, scaleFactor, SwankyImageView.this.viewWidth / 2.0f, SwankyImageView.this.viewHeight / 2.0f);
                }
                if (scaleFactor < 1.0f) {
                    SwankyImageView.this.matrix.getValues(SwankyImageView.this.m);
                    float x = SwankyImageView.this.m[2];
                    float y = SwankyImageView.this.m[5];
                    if ((float)Math.round(SwankyImageView.this.origWidth * SwankyImageView.this.saveScale) < SwankyImageView.this.viewWidth) {
                        if (y < -SwankyImageView.this.bottom) {
                            SwankyImageView.this.matrix.postTranslate(0.0f, -(y + SwankyImageView.this.bottom));
                        } else if (y > 0.0f) {
                            SwankyImageView.this.matrix.postTranslate(0.0f, -y);
                        }
                    } else if (x < -SwankyImageView.this.right) {
                        SwankyImageView.this.matrix.postTranslate(-(x + SwankyImageView.this.right), 0.0f);
                    } else if (x > 0.0f) {
                        SwankyImageView.this.matrix.postTranslate(-x, 0.0f);
                    }
                    if (!SwankyImageView.this.isCenterInside) {
                        SwankyImageView.this.matrix.postTranslate(-x - SwankyImageView.this.right / 2.0f, SwankyImageView.this.bottom / 2.0f - y);
                    }
                }
            } else {
                SwankyImageView.this.matrix.postScale(scaleFactor, scaleFactor, this.centerX, this.centerY);
                SwankyImageView.this.matrix.getValues(SwankyImageView.this.m);
                float x = SwankyImageView.this.m[2];
                float y = SwankyImageView.this.m[5];
                if (scaleFactor < 1.0f) {
                    if (x < -SwankyImageView.this.right) {
                        SwankyImageView.this.matrix.postTranslate(-(x + SwankyImageView.this.right), 0.0f);
                    } else if (x > 0.0f) {
                        SwankyImageView.this.matrix.postTranslate(-x, 0.0f);
                    }
                    if (y < -SwankyImageView.this.bottom) {
                        SwankyImageView.this.matrix.postTranslate(0.0f, -(y + SwankyImageView.this.bottom));
                    } else if (y > 0.0f) {
                        SwankyImageView.this.matrix.postTranslate(0.0f, -y);
                    }
                }
            }
            SwankyImageView.this.setImageMatrix(SwankyImageView.this.matrix);
            SwankyImageView.this.invalidate();
        }
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        @Override
        public boolean onScaleBegin(ScaleGestureDetector detector) {
            SwankyImageView.this.mode = 2;
            return true;
        }

        @Override
        public boolean onScale(ScaleGestureDetector detector) {
            boolean viewTallerThanImg;
            float mScaleFactor = (float)Math.min((double)Math.max(0.95f, detector.getScaleFactor()), 1.05);
            float origScale = SwankyImageView.this.saveScale;
            SwankyImageView.this.saveScale *= mScaleFactor;
            if (SwankyImageView.this.saveScale > SwankyImageView.this.maxScale) {
                SwankyImageView.this.saveScale = SwankyImageView.this.maxScale;
                mScaleFactor = SwankyImageView.this.maxScale / origScale;
            } else if (SwankyImageView.this.saveScale < 1.0f) {
                SwankyImageView.this.saveScale = 1.0f;
                mScaleFactor = 1.0f / origScale;
            }
            SwankyImageView.this.right = SwankyImageView.this.viewWidth * SwankyImageView.this.saveScale - SwankyImageView.this.viewWidth - 2.0f * SwankyImageView.this.redundantXSpace * SwankyImageView.this.saveScale;
            SwankyImageView.this.bottom = SwankyImageView.this.viewHeight * SwankyImageView.this.saveScale - SwankyImageView.this.viewHeight - 2.0f * SwankyImageView.this.redundantYSpace * SwankyImageView.this.saveScale;
            boolean viewWiderThanImg = SwankyImageView.this.origWidth * SwankyImageView.this.saveScale <= SwankyImageView.this.viewWidth;
            boolean bl = viewTallerThanImg = SwankyImageView.this.origHeight * SwankyImageView.this.saveScale <= SwankyImageView.this.viewHeight;
            if (viewWiderThanImg || viewTallerThanImg) {
                if (viewWiderThanImg && !viewTallerThanImg) {
                    SwankyImageView.this.matrix.postScale(mScaleFactor, mScaleFactor, SwankyImageView.this.viewWidth / 2.0f, detector.getFocusY());
                } else if (!viewWiderThanImg && viewTallerThanImg) {
                    SwankyImageView.this.matrix.postScale(mScaleFactor, mScaleFactor, detector.getFocusX(), SwankyImageView.this.viewHeight / 2.0f);
                } else {
                    SwankyImageView.this.matrix.postScale(mScaleFactor, mScaleFactor, SwankyImageView.this.viewWidth / 2.0f, SwankyImageView.this.viewHeight / 2.0f);
                }
                if (mScaleFactor < 1.0f) {
                    SwankyImageView.this.matrix.getValues(SwankyImageView.this.m);
                    float x = SwankyImageView.this.m[2];
                    float y = SwankyImageView.this.m[5];
                    if ((float)Math.round(SwankyImageView.this.origWidth * SwankyImageView.this.saveScale) < SwankyImageView.this.viewWidth) {
                        if (y < -SwankyImageView.this.bottom) {
                            SwankyImageView.this.matrix.postTranslate(0.0f, -(y + SwankyImageView.this.bottom));
                        } else if (y > 0.0f) {
                            SwankyImageView.this.matrix.postTranslate(0.0f, -y);
                        }
                    } else if (x < -SwankyImageView.this.right) {
                        SwankyImageView.this.matrix.postTranslate(-(x + SwankyImageView.this.right), 0.0f);
                    } else if (x > 0.0f) {
                        SwankyImageView.this.matrix.postTranslate(-x, 0.0f);
                    }
                    if (!SwankyImageView.this.isCenterInside) {
                        SwankyImageView.this.matrix.postTranslate(-x - SwankyImageView.this.right / 2.0f, SwankyImageView.this.bottom / 2.0f - y);
                    }
                }
            } else {
                SwankyImageView.this.matrix.postScale(mScaleFactor, mScaleFactor, detector.getFocusX(), detector.getFocusY());
                SwankyImageView.this.matrix.getValues(SwankyImageView.this.m);
                float x = SwankyImageView.this.m[2];
                float y = SwankyImageView.this.m[5];
                if (mScaleFactor < 1.0f) {
                    if (x < -SwankyImageView.this.right) {
                        SwankyImageView.this.matrix.postTranslate(-(x + SwankyImageView.this.right), 0.0f);
                    } else if (x > 0.0f) {
                        SwankyImageView.this.matrix.postTranslate(-x, 0.0f);
                    }
                    if (y < -SwankyImageView.this.bottom) {
                        SwankyImageView.this.matrix.postTranslate(0.0f, -(y + SwankyImageView.this.bottom));
                    } else if (y > 0.0f) {
                        SwankyImageView.this.matrix.postTranslate(0.0f, -y);
                    }
                }
            }
            return true;
        }
    }

    private class FlingTask
    extends AsyncTask<Void, Void, Void> {
        private long curTimestamp;
        private float velX;
        private float velY;

        public FlingTask(long prevTimestamp, float velX, float velY) {
            SwankyImageView.this.lastFrameCompleted = SwankyImageView.this.timeOfLastMoveEvent;
            this.velX = velX;
            this.velY = velY;
        }

        protected Void doInBackground(Void ... params) {
            SwankyImageView.this.FLING_ANIM_HANDLER.sendEmptyMessage(1);
            while (!this.isCancelled()) {
                this.curTimestamp = System.currentTimeMillis();
                int deltaT = (int)(this.curTimestamp - SwankyImageView.this.lastFrameCompleted);
                SwankyImageView.this.matrix.getValues(SwankyImageView.this.m);
                float x = SwankyImageView.this.m[2];
                float y = SwankyImageView.this.m[5];
                float deltaX = this.velX * (float)deltaT;
                float deltaY = this.velY * (float)deltaT;
                float scaleWidth = Math.round(SwankyImageView.this.origWidth * SwankyImageView.this.saveScale);
                float scaleHeight = Math.round(SwankyImageView.this.origHeight * SwankyImageView.this.saveScale);
                if (scaleWidth <= SwankyImageView.this.viewWidth) {
                    deltaX = 0.0f;
                    this.velX = 0.0f;
                } else if (x + deltaX >= 0.0f) {
                    deltaX = -x;
                    this.velX = 0.0f;
                } else if (x + deltaX <= -SwankyImageView.this.right) {
                    deltaX = -x - SwankyImageView.this.right;
                    this.velX = 0.0f;
                }
                if (scaleHeight <= SwankyImageView.this.viewHeight) {
                    deltaY = 0.0f;
                    this.velY = 0.0f;
                } else if (y + deltaY >= 0.0f) {
                    deltaY = -y;
                    this.velY = 0.0f;
                } else if (y + deltaY <= -SwankyImageView.this.bottom) {
                    deltaY = -y - SwankyImageView.this.bottom;
                    this.velY = 0.0f;
                }
                if (this.velX != 0.0f) {
                    this.velX *= 1.0f - 0.01f * (float)deltaT;
                }
                if (this.velY != 0.0f) {
                    this.velY *= 1.0f - 0.01f * (float)deltaT;
                }
                if (Math.abs(this.velX) < 0.05f && Math.abs(this.velY) < 0.05f) {
                    this.velY = 0.0f;
                    this.velX = 0.0f;
                }
                SwankyImageView.this.matrix.postTranslate(deltaX, deltaY);
                SwankyImageView.this.lastFrameCompleted = this.curTimestamp;
                if (this.velX != 0.0f || this.velY != 0.0f) continue;
                return null;
            }
            return null;
        }

        protected void onPostExecute(Void result) {
            SwankyImageView.this.FLING_ANIM_HANDLER.sendEmptyMessage(2);
            SwankyImageView.this.mFlingTask = null;
        }

        protected void onCancelled() {
            SwankyImageView.this.FLING_ANIM_HANDLER.sendEmptyMessage(2);
            SwankyImageView.this.mFlingTask = null;
        }
    }

    private class TapSwipeListener
    extends GestureDetector.SimpleOnGestureListener {
        private TapSwipeListener() {
        }

        public boolean onDoubleTap(MotionEvent e) {
            ZoomAnimation anim = SwankyImageView.this.saveScale > 1.0f ? new ZoomAnimation(SwankyImageView.this.saveScale, 1.0f, e.getX(), e.getY()) : new ZoomAnimation(1.0f, SwankyImageView.this.maxScale, e.getX(), e.getY());
            SwankyImageView.this.startAnimation(anim);
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            SwankyImageView.this.onClick();
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            SwankyImageView.this.mode = 0;
            SwankyImageView.this.mFlingTask = new FlingTask(SwankyImageView.this.timeOfLastMoveEvent, velocityX / 1000.0f, velocityY / 1000.0f).execute(new Void[0]);
            return true;
        }
    }
}

