/*
 * Decompiled with CFR 0.152.
 */
package oak;

import android.content.Context;
import android.graphics.Canvas;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.Log;
import oak.TextViewWithFont;

public class ResizedTextView
extends TextViewWithFont {
    private int numMaxLines;
    private int numMinTextSize;
    private int numLines;
    private int numTextSize;
    private final Canvas resizeCanvas = new Canvas();

    public ResizedTextView(Context context) {
        this(context, null);
    }

    public ResizedTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ResizedTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.numMaxLines = attrs.getAttributeIntValue("http://schemas.android.com/apk/res/android", "maxLines", 2);
        this.numMinTextSize = attrs.getAttributeIntValue("http://oak/oak/schema", "minTextSize", 11);
    }

    public void setTextSize(float size) {
        super.setTextSize(size);
        this.numTextSize = (int)size;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (changed) {
            int maxWidth = right - left - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
            int maxHeight = bottom - top - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom();
            CharSequence text = this.getText();
            TextPaint textPaint = this.getPaint();
            int textHeight = this.getTextHeight(text, textPaint, maxWidth, this.numMinTextSize);
            while (textHeight < maxHeight && this.numLines <= this.numMaxLines) {
                Log.d((String)"OAK", (String)("Trying text size: " + (this.numTextSize + 1)));
                textHeight = this.getTextHeight(text, textPaint, maxWidth, this.numTextSize + 1);
                Log.d((String)"OAK", (String)("Numlines: " + this.numLines));
                Log.d((String)"OAK", (String)("Height is: " + textHeight + " Of " + maxHeight));
            }
            if (this.numLines > this.numMaxLines) {
                textPaint.setTextSize((float)this.numTextSize);
                StaticLayout tempLayout = this.createWorkingLayout(text, textPaint, maxWidth);
                tempLayout.draw(this.resizeCanvas);
                int EndOfLine = tempLayout.getLineEnd(this.numLines - 1);
                while (this.createWorkingLayout(text.subSequence(0, EndOfLine - 4) + "...", textPaint, maxWidth).getLineCount() > this.numMaxLines) {
                    --EndOfLine;
                }
                Log.d((String)"OAK", (String)("Text was: \"" + text + "\" now is: " + text.subSequence(0, EndOfLine - 4) + "..."));
                this.setText(text.subSequence(0, EndOfLine - 4) + "...");
            }
            textPaint.setTextSize((float)this.numTextSize);
            this.setLineSpacing(0.0f, 1.0f);
        }
        super.onLayout(changed, left, right, top, bottom);
    }

    private int getTextHeight(CharSequence text, TextPaint paint, int width, int textSize) {
        paint.setTextSize((float)textSize);
        this.numTextSize = textSize;
        StaticLayout tempLayout = this.createWorkingLayout(text, paint, width);
        tempLayout.draw(this.resizeCanvas);
        this.numLines = tempLayout.getLineCount();
        return tempLayout.getHeight();
    }

    private StaticLayout createWorkingLayout(CharSequence text, TextPaint paint, int width) {
        return new StaticLayout(text, paint, width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
    }
}

