/*
 * Decompiled with CFR 0.152.
 */
package oak;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.net.ssl.SSLException;
import oak.ImageTransformation;
import oak.OAKImageCache;
import oak.OAKImageLoaderHandler;
import oak.external.com.github.droidfu.imageloader.ImageLoader;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.AbstractVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHttpRequest;

public class OAKImageLoader
extends ImageLoader
implements Runnable {
    private static final String LOG_TAG = OAKImageLoader.class.getSimpleName();
    private String imageUrl;
    private String printedUrl;
    private OAKImageLoaderHandler handler;
    private ImageTransformation[] transformations;
    private static OAKImageCache imageCache;
    public static final int NO_DISK_CACHING = 0;
    public static final int INTERNAL_CACHING = 1;
    public static final int SD_CACHING = 2;
    public static final int PREFER_INTERNAL = 3;
    public static final int PREFER_SD = 4;
    private static Drawable defaultLoading;
    private static Drawable defaultError;
    public static boolean spinLoading;
    private static boolean safeMode;
    private static int bytesPerPixel;
    private static Map<String, Integer> areaMap;
    private static Context context;

    public static synchronized void initialize(Context context, int cacheType) {
        OAKImageLoader.context = context;
        if (executor == null) {
            executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(3);
        }
        if (imageCache == null) {
            imageCache = new OAKImageCache(25, expirationInMinutes, 3);
            switch (cacheType) {
                case 0: {
                    break;
                }
                case 1: {
                    imageCache.enableDiskCache(context, 0);
                    break;
                }
                case 2: {
                    imageCache.enableDiskCache(context, 1);
                    break;
                }
                case 3: {
                    if (imageCache.enableDiskCache(context, 0)) break;
                    imageCache.enableDiskCache(context, 1);
                    break;
                }
                case 4: {
                    if (imageCache.enableDiskCache(context, 1)) break;
                    imageCache.enableDiskCache(context, 0);
                    break;
                }
                default: {
                    if (imageCache.enableDiskCache(context, 1)) break;
                    imageCache.enableDiskCache(context, 0);
                }
            }
            imageCache.updateContents();
            Log.d((String)"OAKImageLoader", (String)("Caching to " + imageCache.getDiskCacheDirectory()));
        }
    }

    public static OAKImageCache getImageCache() {
        return imageCache;
    }

    private OAKImageLoader(String imageUrl, String printedUrl, OAKImageLoaderHandler handler, ImageTransformation ... transformations) {
        super(imageUrl, handler);
        this.imageUrl = imageUrl;
        this.handler = handler;
        this.printedUrl = printedUrl;
        this.transformations = transformations;
    }

    public static void start(String imageUrl, OAKImageLoaderHandler handler) {
        OAKImageLoader.start(imageUrl, handler.getImageView(), handler, null, null, new ImageTransformation[0]);
    }

    public static void start(String imageUrl, OAKImageLoaderHandler handler, ImageTransformation ... transformations) {
        OAKImageLoader.start(imageUrl, handler.getImageView(), handler, null, null, transformations);
    }

    public static void start(String imageUrl, ImageView imageView, Drawable dummyDrawable, Drawable errorDrawable) {
        OAKImageLoader.start(imageUrl, imageView, new OAKImageLoaderHandler(imageView, imageUrl), dummyDrawable, errorDrawable, new ImageTransformation[0]);
    }

    public static void start(String imageUrl, ImageView imageView, Drawable dummyDrawable, Drawable errorDrawable, ImageTransformation ... transformations) {
        OAKImageLoader.start(imageUrl, imageView, new OAKImageLoaderHandler(imageView, imageUrl), dummyDrawable, errorDrawable, transformations);
    }

    public static void start(String imageUrl, ImageView imageView) {
        OAKImageLoader.start(imageUrl, imageView, new OAKImageLoaderHandler(imageView, imageUrl), null, null, new ImageTransformation[0]);
    }

    public static void start(String imageUrl, ImageView imageView, ImageTransformation ... transformations) {
        OAKImageLoader.start(imageUrl, imageView, new OAKImageLoaderHandler(imageView, imageUrl), null, null, transformations);
    }

    public static void start(String imageUrl, OAKImageLoaderHandler handler, Drawable dummyDrawable, Drawable errorDrawable, ImageTransformation ... transformations) {
        OAKImageLoader.start(imageUrl, handler.getImageView(), handler, dummyDrawable, errorDrawable, transformations);
    }

    public static void start(String imageUrl, OAKImageLoaderHandler handler, Drawable dummyDrawable, Drawable errorDrawable) {
        OAKImageLoader.start(imageUrl, handler.getImageView(), handler, dummyDrawable, errorDrawable, new ImageTransformation[0]);
    }

    protected static void start(String imageUrl, ImageView imageView, OAKImageLoaderHandler handler, Drawable dummyDrawable, Drawable errorDrawable, ImageTransformation ... transformations) {
        if (handler == null) {
            OAKImageLoader.preCache(new String[]{imageUrl}, transformations);
            return;
        }
        dummyDrawable = dummyDrawable == null ? defaultLoading : dummyDrawable;
        errorDrawable = errorDrawable == null ? defaultError : errorDrawable;
        String printedUrl = OAKImageLoader.getPrintedUrl(imageUrl, transformations);
        if (imageView != null) {
            if (imageUrl == null) {
                imageView.setTag(null);
                OAKImageLoader.setLoading(imageView, dummyDrawable);
                return;
            }
            String oldImageUrl = (String)imageView.getTag();
            if (printedUrl.equals(oldImageUrl)) {
                return;
            }
            OAKImageLoader.setLoading(imageView, dummyDrawable);
            imageView.setTag((Object)printedUrl);
        }
        if (imageCache.containsKeyInMemory(printedUrl)) {
            handler.setPrintedUrl(printedUrl);
            handler.handleImageLoaded(imageCache.getBitmap(printedUrl), null);
        } else {
            executor.execute(new OAKImageLoader(imageUrl, printedUrl, handler, transformations));
        }
    }

    public static String getPrintedUrl(String originalUrl, ImageTransformation ... transformations) {
        if (transformations.length == 0) {
            return originalUrl;
        }
        String printedUrl = originalUrl;
        for (ImageTransformation trans : transformations) {
            printedUrl = trans.fingerprint() + printedUrl;
        }
        return printedUrl;
    }

    public static void preCache(String[] urls, ImageTransformation ... transformations) {
        for (String url : urls) {
            String printedUrl = OAKImageLoader.getPrintedUrl(url, transformations);
            executor.execute(new OAKImageLoader(url, printedUrl, null, transformations));
        }
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        if (this.handler == null) {
            if (!imageCache.containsKey(this.printedUrl)) {
                this.downloadImage(true);
            }
            return;
        }
        Bitmap bitmap = imageCache.getBitmap(this.printedUrl);
        if (bitmap == null) {
            bitmap = this.downloadImage(false);
        }
        this.notifyImageLoaded(this.printedUrl, bitmap);
    }

    @Override
    public void notifyImageLoaded(String url, Bitmap bitmap) {
        this.handler.setPrintedUrl(this.printedUrl);
        Message message = new Message();
        message.what = 0;
        Bundle data = new Bundle();
        data.putString("droidfu:extra_image_url", url);
        Bitmap image = bitmap;
        data.putParcelable("droidfu:extra_bitmap", (Parcelable)image);
        message.setData(data);
        this.handler.sendMessage(message);
    }

    protected Bitmap downloadImage(boolean toDiskOnly) {
        Bitmap image = null;
        for (int timesTried = 1; timesTried <= numRetries; ++timesTried) {
            try {
                byte[] imageData = this.retrieveImageData();
                if (imageData == null) break;
                if (this.transformations.length == 0) {
                    if (toDiskOnly) {
                        imageCache.putToDisk(this.imageUrl, imageData);
                    } else {
                        imageCache.put(this.imageUrl, imageData);
                    }
                } else {
                    Bitmap bm = BitmapFactory.decodeByteArray((byte[])imageData, (int)0, (int)imageData.length);
                    for (ImageTransformation trans : this.transformations) {
                        bm = trans.transform(bm);
                    }
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    bm.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)bos);
                    bm.recycle();
                    imageData = bos.toByteArray();
                    if (toDiskOnly) {
                        imageCache.putToDisk(this.printedUrl, imageData);
                    } else {
                        imageCache.put(this.printedUrl, imageData);
                    }
                }
                if (toDiskOnly) break;
                image = BitmapFactory.decodeByteArray((byte[])imageData, (int)0, (int)imageData.length);
                break;
            }
            catch (Throwable e) {
                Log.w((String)LOG_TAG, (String)("download for " + this.imageUrl + " failed (attempt " + timesTried + ")"));
                e.printStackTrace();
                SystemClock.sleep((long)1000L);
                continue;
            }
        }
        return image;
    }

    private HttpClient getHttpClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        SSLSocketFactory sslSocketFactory = (SSLSocketFactory)client.getConnectionManager().getSchemeRegistry().getScheme("https").getSocketFactory();
        X509HostnameVerifier delegate = sslSocketFactory.getHostnameVerifier();
        if (!(delegate instanceof MyVerifier)) {
            sslSocketFactory.setHostnameVerifier((X509HostnameVerifier)new MyVerifier(delegate));
        }
        return client;
    }

    @Override
    protected byte[] retrieveImageData() throws IOException {
        HttpResponse response;
        URL url = new URL(this.imageUrl);
        if (url.getAuthority().contains("_")) {
            HttpHost httpHost = url.getPort() == -1 ? new HttpHost(url.getHost(), 80, url.getProtocol()) : new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
            BasicHttpRequest httpRequest = new BasicHttpRequest("GET", this.imageUrl);
            response = this.getHttpClient().execute(httpHost, (HttpRequest)httpRequest);
        } else {
            HttpGet req = new HttpGet(this.imageUrl);
            response = this.getHttpClient().execute((HttpUriRequest)req);
        }
        BufferedHttpEntity bufResponse = new BufferedHttpEntity(response.getEntity());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bufResponse.writeTo((OutputStream)baos);
        return baos.toByteArray();
    }

    public static void clearCache() {
        imageCache.clear();
    }

    public static Drawable getDefaultLoading() {
        return defaultLoading;
    }

    public static void setDefaultLoading(Drawable defaultLoading) {
        OAKImageLoader.defaultLoading = defaultLoading;
    }

    public static Drawable getDefaultError() {
        return defaultError;
    }

    public static void setDefaultError(Drawable defaultError) {
        OAKImageLoader.defaultError = defaultError;
    }

    public static void setSpinning(View v) {
        RotateAnimation a = new RotateAnimation(0.0f, 360.0f, 0, (float)(v.getWidth() / 2), 0, (float)(v.getHeight() / 2));
        a.setInterpolator((Interpolator)new LinearInterpolator());
        a.setRepeatCount(-1);
        a.setDuration(1L);
        a.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        v.setAnimation((Animation)a);
    }

    public static void setLoading(ImageView v, Drawable loading) {
        if (loading != null) {
            v.setImageDrawable(loading);
            if (spinLoading) {
                OAKImageLoader.setSpinning((View)v);
            }
        }
        v.setVisibility(0);
    }

    public static boolean isSafeMode() {
        return safeMode;
    }

    public static void setSafeMode(boolean safeMode, int bytesPerPixel) {
        OAKImageLoader.safeMode = safeMode;
        OAKImageLoader.bytesPerPixel = bytesPerPixel;
        imageCache.setContext(context);
    }

    static {
        defaultLoading = null;
        defaultError = null;
        spinLoading = false;
        safeMode = false;
        bytesPerPixel = 4;
    }

    class MyVerifier
    extends AbstractVerifier {
        private final X509HostnameVerifier delegate;

        public MyVerifier(X509HostnameVerifier delegate) {
            this.delegate = delegate;
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
        }
    }
}

