/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.support;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;

public class DiagnosticSupport {
    public static final int ANDROID_API_LEVEL;

    public static String getAndroidId(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (androidId == null) {
            androidId = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        return androidId;
    }

    public static String getAndroidId(Context context, String fallbackValue) {
        String androidId = DiagnosticSupport.getAndroidId(context);
        if (androidId == null) {
            androidId = fallbackValue;
        }
        return androidId;
    }

    public static String getApplicationVersionString(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo info = pm.getPackageInfo(context.getPackageName(), 0);
            return "v" + info.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String createDiagnosis(Activity context, Exception error) {
        StringBuilder sb = new StringBuilder();
        sb.append("Application version: " + DiagnosticSupport.getApplicationVersionString((Context)context) + "\n");
        sb.append("Device locale: " + Locale.getDefault().toString() + "\n\n");
        sb.append("Android ID: " + DiagnosticSupport.getAndroidId((Context)context, "n/a"));
        sb.append("PHONE SPECS\n");
        sb.append("model: " + Build.MODEL + "\n");
        sb.append("brand: " + Build.BRAND + "\n");
        sb.append("product: " + Build.PRODUCT + "\n");
        sb.append("device: " + Build.DEVICE + "\n\n");
        sb.append("PLATFORM INFO\n");
        sb.append("Android " + Build.VERSION.RELEASE + " " + Build.ID + " (build " + Build.VERSION.INCREMENTAL + ")\n");
        sb.append("build tags: " + Build.TAGS + "\n");
        sb.append("build type: " + Build.TYPE + "\n\n");
        sb.append("SYSTEM SETTINGS\n");
        String networkMode = null;
        ContentResolver resolver = context.getContentResolver();
        try {
            networkMode = Settings.Secure.getInt((ContentResolver)resolver, (String)"wifi_on") == 0 ? "DATA" : "WIFI";
            sb.append("network mode: " + networkMode + "\n");
            sb.append("HTTP proxy: " + Settings.Secure.getString((ContentResolver)resolver, (String)"http_proxy") + "\n\n");
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
        }
        sb.append("STACK TRACE FOLLOWS\n\n");
        StringWriter stackTrace = new StringWriter();
        error.printStackTrace(new PrintWriter(stackTrace));
        sb.append(stackTrace.toString());
        return sb.toString();
    }

    static {
        int apiLevel = -1;
        try {
            apiLevel = Build.VERSION.class.getField("SDK_INT").getInt(null);
        }
        catch (Exception e) {
            apiLevel = Integer.parseInt(Build.VERSION.SDK);
        }
        ANDROID_API_LEVEL = apiLevel;
    }
}

