/*
 * Decompiled with CFR 0.152.
 */
package oak.external.com.github.droidfu.cachefu;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.util.ArrayList;
import oak.external.com.github.droidfu.cachefu.CachedModel;
import oak.external.com.github.droidfu.cachefu.ModelCache;

public class CachedList<CO extends CachedModel>
extends CachedModel {
    protected Class<? extends CachedModel> clazz;
    protected ArrayList<CO> list;
    public static final Parcelable.Creator<CachedList<CachedModel>> CREATOR = new Parcelable.Creator<CachedList<CachedModel>>(){

        public CachedList<CachedModel> createFromParcel(Parcel source) {
            try {
                return new CachedList<CachedModel>(source);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public CachedList<CachedModel>[] newArray(int size) {
            return new CachedList[size];
        }
    };

    public CachedList() {
        this.list = new ArrayList();
    }

    public CachedList(Parcel source) throws IOException {
        super(source);
    }

    public CachedList(Class<? extends CachedModel> clazz) {
        this.clazz = clazz;
        this.list = new ArrayList();
    }

    public CachedList(Class<? extends CachedModel> clazz, int initialLength) {
        this.clazz = clazz;
        this.list = new ArrayList(initialLength);
    }

    public CachedList(Class<? extends CachedModel> clazz, String id) {
        super(id);
        this.clazz = clazz;
        this.list = new ArrayList();
    }

    public synchronized ArrayList<CO> getList() {
        return new ArrayList<CO>(this.list);
    }

    public synchronized void add(CO cachedObject) {
        this.list.add(cachedObject);
    }

    public synchronized void set(int index, CO cachedObject) {
        this.list.set(index, cachedObject);
    }

    public synchronized CO get(int index) {
        return (CO)((CachedModel)this.list.get(index));
    }

    public synchronized int size() {
        return this.list.size();
    }

    public synchronized boolean equals(Object o) {
        if (!(o instanceof CachedList)) {
            return false;
        }
        CachedList that = (CachedList)o;
        return this.clazz.equals(that.clazz) && this.list.equals(that.list);
    }

    @Override
    public synchronized String createKey(String id) {
        return "list_" + id;
    }

    @Override
    public boolean reload(ModelCache modelCache) {
        boolean result = super.reload(modelCache);
        for (int i = 0; i < this.list.size(); ++i) {
            CachedModel listModel = (CachedModel)this.list.get(i);
            if (!listModel.reload(modelCache)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public synchronized boolean reloadFromCachedModel(ModelCache modelCache, CachedModel cachedModel) {
        CachedList cachedList = (CachedList)cachedModel;
        this.clazz = cachedList.clazz;
        this.list = cachedList.list;
        return false;
    }

    @Override
    public void readFromParcel(Parcel source) throws IOException {
        super.readFromParcel(source);
        String className = source.readString();
        try {
            this.clazz = Class.forName(className);
            this.list = source.createTypedArrayList((Parcelable.Creator)this.clazz.getField("CREATOR").get(this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.clazz.getCanonicalName());
        dest.writeTypedList(this.list);
    }
}

