/*
 * Decompiled with CFR 0.152.
 */
package oak;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import oak.BaseSectionAdapter;

public class SectionListView
extends ListView {
    public static final String TAG = SectionListView.class.getSimpleName();
    private View mHeaderView;
    private boolean mHeaderViewVisible;
    private int mHeaderViewWidth;
    private int mHeaderViewHeight;
    private BaseSectionAdapter mAdapter;

    public void setPinnedHeaderView(View view) {
        this.mHeaderView = view;
        if (this.mHeaderView != null) {
            this.setFadingEdgeLength(0);
        }
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mHeaderView != null) {
            this.measureChild(this.mHeaderView, widthMeasureSpec, heightMeasureSpec);
            this.mHeaderViewWidth = this.mHeaderView.getMeasuredWidth();
            this.mHeaderViewHeight = this.mHeaderView.getMeasuredHeight();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mHeaderView != null) {
            this.mHeaderView.layout(0, 0, this.mHeaderViewWidth, this.mHeaderViewHeight);
            this.configureHeaderView(this.getFirstVisiblePosition());
        }
    }

    public void configureHeaderView(int position) {
        if (this.mHeaderView == null) {
            return;
        }
        int state = this.mAdapter.getPinnedHeaderState(position);
        switch (state) {
            case 0: {
                this.mHeaderViewVisible = false;
                break;
            }
            case 1: {
                this.mAdapter.configurePinnedHeader(this.mHeaderView, position, 255);
                if (this.mHeaderView.getTop() != 0) {
                    this.mHeaderView.layout(0, 0, this.mHeaderViewWidth, this.mHeaderViewHeight);
                }
                this.mHeaderViewVisible = true;
                break;
            }
            case 2: {
                int alpha;
                int y;
                int headerHeight;
                View firstView = this.getChildAt(0);
                if (firstView == null) break;
                int bottom = firstView.getBottom();
                if (bottom < (headerHeight = this.mHeaderView.getHeight())) {
                    y = bottom - headerHeight;
                    alpha = 255 * (headerHeight + y) / headerHeight;
                } else {
                    y = 0;
                    alpha = 255;
                }
                this.mAdapter.configurePinnedHeader(this.mHeaderView, position, alpha);
                if (this.mHeaderView.getTop() != y) {
                    this.mHeaderView.layout(0, y, this.mHeaderViewWidth, this.mHeaderViewHeight + y);
                }
                this.mHeaderViewVisible = true;
                break;
            }
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mHeaderViewVisible) {
            this.drawChild(canvas, this.mHeaderView, this.getDrawingTime());
        }
    }

    public SectionListView(Context context) {
        super(context);
    }

    public SectionListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SectionListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setAdapter(ListAdapter adapter) {
        if (!(adapter instanceof BaseSectionAdapter)) {
            throw new IllegalArgumentException(SectionListView.class.getSimpleName() + " must use adapter of type " + BaseSectionAdapter.class.getSimpleName());
        }
        if (this.mAdapter != null) {
            this.setOnScrollListener(null);
        }
        this.mAdapter = (BaseSectionAdapter)adapter;
        this.setOnScrollListener((BaseSectionAdapter)adapter);
        View dummy = new View(this.getContext());
        super.addFooterView(dummy);
        super.setAdapter(adapter);
        super.removeFooterView(dummy);
    }

    public BaseSectionAdapter getAdapter() {
        return this.mAdapter;
    }
}

