/*
 * Decompiled with CFR 0.152.
 */
package oak;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.ArrowKeyMovementMethod;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.TextView;
import oak.TextViewWithFont;

public class CancelEditText
extends TextViewWithFont {
    private Drawable mDrawable;

    public CancelEditText(Context context) {
        this(context, null);
    }

    public CancelEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 16842862);
    }

    public CancelEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int cancelDrawableId = 0;
        if (attrs != null) {
            cancelDrawableId = attrs.getAttributeResourceValue("http://oak/oak/schema", "cancelDrawable", 0);
        }
        if (cancelDrawableId != 0) {
            this.mDrawable = this.getResources().getDrawable(cancelDrawableId);
            this.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    CancelEditText.this.showOrHideCancel();
                }

                public void afterTextChanged(Editable s) {
                }
            });
            this.showOrHideCancel();
        }
    }

    private void showOrHideCancel() {
        this.setCancelVisible(this.getText().length() > 0);
    }

    private void setCancelVisible(boolean visible) {
        if (visible) {
            this.setCompoundDrawablesWithIntrinsicBounds(null, null, this.mDrawable, null);
        } else {
            this.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mDrawable != null && event.getX() > (float)(this.getWidth() - this.getPaddingRight() - this.mDrawable.getIntrinsicWidth())) {
            this.setText("");
            this.setCancelVisible(false);
        }
        return super.onTouchEvent(event);
    }

    protected boolean getDefaultEditable() {
        return true;
    }

    protected MovementMethod getDefaultMovementMethod() {
        return ArrowKeyMovementMethod.getInstance();
    }

    public Editable getText() {
        return (Editable)super.getText();
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, TextView.BufferType.EDITABLE);
    }

    public void setSelection(int start, int stop) {
        Selection.setSelection((Spannable)this.getText(), (int)start, (int)stop);
    }

    public void setSelection(int index) {
        Selection.setSelection((Spannable)this.getText(), (int)index);
    }

    public void selectAll() {
        Selection.selectAll((Spannable)this.getText());
    }

    public void extendSelection(int index) {
        Selection.extendSelection((Spannable)this.getText(), (int)index);
    }

    public void setEllipsize(TextUtils.TruncateAt ellipsis) {
        if (ellipsis == TextUtils.TruncateAt.MARQUEE) {
            throw new IllegalArgumentException("EditText cannot use the ellipsize mode TextUtils.TruncateAt.MARQUEE");
        }
        super.setEllipsize(ellipsis);
    }
}

